/*
 * Copyright (c) 2004-2006, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
package com.volatileengine.image.loader;

import java.io.IOException;
import java.io.InputStream;

import com.volatileengine.VolatileEngineException;
import com.volatileengine.image.Texture;
import com.volatileengine.image.Texture.ImageFilter;
import com.volatileengine.resources.IResourceFinder;
import com.volatileengine.resources.IResourceLoader;

/**
 * TODO: Document me
 * 
 * @author ChaosDeathFish
 */
public class TextureLoader implements IResourceLoader<Texture, Object> {
	private IResourceFinder finder;
	private ImageFilter magnificationFilter;
	private ImageFilter minificationFilter;

	/**
	 * TextureLoader constructor.
	 * 
	 * @param finder
	 */
	public TextureLoader(IResourceFinder finder) {
		this.finder = finder;
		magnificationFilter = ImageFilter.LINEAR;
		minificationFilter = ImageFilter.LINEAR;
	}

	public Texture load(String name, Object n) throws IOException {
		InputStream url = finder.findResource(name);
		if (url == null) {
			return null;
		}

		if (name.endsWith("dds") || n.equals("dds")) {
			DDSReader reader = new DDSReader(url);
			return reader.createImage(name);
		}

		throw new VolatileEngineException("Could not load texture (" + name + ") as decoder was not found");
	}

	/**
	 * @return the magnificationFilter
	 */
	public ImageFilter getMagnificationFilter() {
		return magnificationFilter;
	}

	/**
	 * @param magnificationFilter
	 *             the magnificationFilter to set
	 */
	public void setMagnificationFilter(ImageFilter magnificationFilter) {
		this.magnificationFilter = magnificationFilter;
	}

	/**
	 * @return the minificationFilter
	 */
	public ImageFilter getMinificationFilter() {
		return minificationFilter;
	}

	/**
	 * @param minificationFilter
	 *             the minificationFilter to set
	 */
	public void setMinificationFilter(ImageFilter minificationFilter) {
		this.minificationFilter = minificationFilter;
	}
}
