/*
 * Copyright (c) 2004-2006, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 * 
 */
package com.volatileengine.material;

import com.volatileengine.material.shader.ShaderProgram;
import com.volatileengine.material.states.AlphaBlendingRenderState;
import com.volatileengine.material.states.AlphaTestRenderState;
import com.volatileengine.material.states.CullFaceRenderState;
import com.volatileengine.material.states.DepthRenderState;
import com.volatileengine.material.states.LightRenderState;
import com.volatileengine.material.states.PolygonOffsetRenderState;
import com.volatileengine.material.states.StencilRenderState;
import com.volatileengine.material.states.TextureRenderState;
import com.volatileengine.material.states.WireframeRenderState;

/**
 * @author Administrator
 * 
 */
public class Pass {

	private ShaderProgram shaderProgram;
	private AlphaBlendingRenderState alphaBlendingRenderState;
	private AlphaTestRenderState alphaTestRenderState;
	private CullFaceRenderState cullFaceRenderState;
	private DepthRenderState depthRenderState;
	private LightRenderState lightRenderState;
	private PolygonOffsetRenderState polygonOffsetRenderState;
	private StencilRenderState stencilRenderState;
	private TextureRenderState textureRenderState;
	private WireframeRenderState wireframeRenderState;

	public Pass(ShaderProgram program) {
		this.shaderProgram = program;
	}

	public ShaderProgram getShaderProgram() {
		return shaderProgram;
	}

	/**
	 * @return the alphaBlendingRenderState
	 */
	public AlphaBlendingRenderState getAlphaBlendingRenderState() {
		return alphaBlendingRenderState;
	}

	/**
	 * @param alphaBlendingRenderState
	 *             the alphaBlendingRenderState to set
	 */
	public void setAlphaBlendingRenderState(AlphaBlendingRenderState alphaBlendingRenderState) {
		this.alphaBlendingRenderState = alphaBlendingRenderState;
	}

	/**
	 * @return the alphaTestRenderState
	 */
	public AlphaTestRenderState getAlphaTestRenderState() {
		return alphaTestRenderState;
	}

	/**
	 * @param alphaTestRenderState
	 *             the alphaTestRenderState to set
	 */
	public void setAlphaTestRenderState(AlphaTestRenderState alphaTestRenderState) {
		this.alphaTestRenderState = alphaTestRenderState;
	}

	/**
	 * @return the cullFaceRenderState
	 */
	public CullFaceRenderState getCullFaceRenderState() {
		return cullFaceRenderState;
	}

	/**
	 * @param cullFaceRenderState
	 *             the cullFaceRenderState to set
	 */
	public void setCullFaceRenderState(CullFaceRenderState cullFaceRenderState) {
		this.cullFaceRenderState = cullFaceRenderState;
	}

	/**
	 * @return the depthRenderState
	 */
	public DepthRenderState getDepthRenderState() {
		return depthRenderState;
	}

	/**
	 * @param depthRenderState
	 *             the depthRenderState to set
	 */
	public void setDepthRenderState(DepthRenderState depthRenderState) {
		this.depthRenderState = depthRenderState;
	}

	/**
	 * @return the lightRenderState
	 */
	public LightRenderState getLightRenderState() {
		return lightRenderState;
	}

	/**
	 * @param lightRenderState
	 *             the lightRenderState to set
	 */
	public void setLightRenderState(LightRenderState lightRenderState) {
		this.lightRenderState = lightRenderState;
	}

	/**
	 * @return the polygonOffsetRenderState
	 */
	public PolygonOffsetRenderState getPolygonOffsetRenderState() {
		return polygonOffsetRenderState;
	}

	/**
	 * @param polygonOffsetRenderState
	 *             the polygonOffsetRenderState to set
	 */
	public void setPolygonOffsetRenderState(PolygonOffsetRenderState polygonOffsetRenderState) {
		this.polygonOffsetRenderState = polygonOffsetRenderState;
	}

	/**
	 * @return the stencilRenderState
	 */
	public StencilRenderState getStencilRenderState() {
		return stencilRenderState;
	}

	/**
	 * @param stencilRenderState
	 *             the stencilRenderState to set
	 */
	public void setStencilRenderState(StencilRenderState stencilRenderState) {
		this.stencilRenderState = stencilRenderState;
	}

	/**
	 * @return the textureRenderState
	 */
	public TextureRenderState getTextureRenderState() {
		return textureRenderState;
	}

	/**
	 * @param textureRenderState
	 *             the textureRenderState to set
	 */
	public void setTextureRenderState(TextureRenderState textureRenderState) {
		this.textureRenderState = textureRenderState;
	}

	/**
	 * @return the wireframeRenderState
	 */
	public WireframeRenderState getWireframeRenderState() {
		return wireframeRenderState;
	}

	/**
	 * @param wireframeRenderState
	 *             the wireframeRenderState to set
	 */
	public void setWireframeRenderState(WireframeRenderState wireframeRenderState) {
		this.wireframeRenderState = wireframeRenderState;
	}
}
