/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.volatileengine.material.shader.xml;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import com.volatileengine.material.shader.ShaderObject;
import com.volatileengine.material.shader.ShaderType;
import com.volatileengine.xml.IFileLoader;
import com.volatileengine.xml.XMLParsingException;
import com.volatileengine.xml.elements.Element;
import com.volatileengine.xml.elements.SimpleXMLElement;

/**
 * 
 * @author Administrator
 */
public class ShaderObjectXMLElement extends SimpleXMLElement<ShaderObject> {

	public String getAssociatedTag() {
		return "shaderObject";
	}

	public Element<?> instantiateChild(String tagName, IFileLoader<?> loader) {
		throw new XMLParsingException(getAssociatedTag() + " does not have any children to instantiate");
	}

	public void endElement(IFileLoader<?> loader) {
		byte[] program = text.toString().getBytes();

		ByteBuffer buffer = ByteBuffer.allocateDirect(program.length).order(ByteOrder.nativeOrder());
		buffer.put(program);
		buffer.rewind();

		String shadertype = attributes.get("type");

		ShaderType type = null;
		if ("fragment".equalsIgnoreCase(shadertype)) {
			type = ShaderType.FRAGMENT;
		} else if ("vertex".equalsIgnoreCase(shadertype)) {
			type = ShaderType.VERTEX;
		}

		value = new ShaderObject(buffer, type);
	}

	public void processChild(Element<?> child, IFileLoader<?> loader) {
		throw new XMLParsingException(getAssociatedTag() + " does not have any children to process");
	}
}
