package com.volatileengine.material.states.xml;

import com.volatileengine.material.states.DepthRenderState;
import com.volatileengine.material.states.RenderState.CompareFunc;
import com.volatileengine.xml.IFileLoader;
import com.volatileengine.xml.XMLParsingException;
import com.volatileengine.xml.elements.Element;
import com.volatileengine.xml.elements.EnumXMLElement;
import com.volatileengine.xml.elements.SimpleXMLElement;

public class DepthRenderStateXMLElement extends SimpleXMLElement<DepthRenderState> {

	private CompareFunc compare;

	@Override
	public void endElement(IFileLoader<?> loader) {
		value = new DepthRenderState();
		value.setEnabled(Boolean.valueOf(getAttributes().get("enabled")));
		value.setDepthFunc(compare);

	}

	@Override
	public String getAssociatedTag() {
		return "depthRenderState";
	}

	@Override
	public Element<?> instantiateChild(String tagName, IFileLoader<?> loader) {
		if (tagName.equalsIgnoreCase("enum")) {
			return new EnumXMLElement();
		}

		throw new XMLParsingException(tagName + " is not a valid child of " + getAssociatedTag());
	}

	@Override
	public void processChild(Element<?> child, IFileLoader<?> loader) {
		if (child.getAssociatedTag().equalsIgnoreCase("enum")) {
			if (child.getValue() instanceof CompareFunc) {
				compare = (CompareFunc) ((EnumXMLElement) child).getValue();
			} else {
				throw new XMLParsingException("enum must be CompareFunc");
			}

		}

	}

}
