/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.volatileengine.platform;

import java.util.ArrayList;
import java.util.List;

import com.volatileengine.scene.WindowSurface;

/**
 * 
 * @author Owner
 */
public abstract class AbstractPlatform {

	private List<GPUChannel> channels;
	protected GPU renderer;

	public AbstractPlatform() {
		channels = new ArrayList<GPUChannel>();
	}

	public void openChannel(GPUChannel channel) {
		synchronized (channels) {
			channels.add(channel);
		}
	}

	public void closeChannel(GPUChannel channel) {
		synchronized (channels) {
			channels.remove(channel);
		}
	}

	public abstract void createWindow(WindowSurface surface);

	public abstract void start();

	public abstract void destory();

	protected void render() {
		synchronized (channels) {
			for (int i = 0; i < channels.size(); i++) {
				GPUChannel channel = channels.get(i);
				if (channel.isLocked() != false) {
					for (int j = 0; j < channel.getCommands().size(); j++) {
						channel.getCommands().get(j).execute(renderer);
					}

					channel.clear();
					channel.unlock();
				}
			}
		}
	}
}
