/*
 * Copyright (c) 2004-2006, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 * 
 */
package com.volatileengine.platform;

import java.util.List;

import javax.vecmath.Vector2f;

import com.volatileengine.datatypes.AcceleratedArray;
import com.volatileengine.image.Mipmap;
import com.volatileengine.image.Texture;
import com.volatileengine.material.shader.ShaderObject;
import com.volatileengine.material.shader.ShaderProgram;
import com.volatileengine.material.shader.variable.ShaderVariable;
import com.volatileengine.scene.Frustum;
import com.volatileengine.scene.SceneMesh;
import com.volatileengine.scene.Surface;

/**
 * @author Administrator
 * 
 */
public interface GPU {

	public void initialise();

	public void prepareSurfaces(Surface[] canvas);

	public void showSurfaces(Surface[] canvas);

	public void project2D(float left, float right, float bottom, float top);

	public void viewport(Vector2f position, Vector2f dimension);

	public void project3D(Frustum perspective);

	public void draw(List<SceneMesh> mesh);

	public void clear(Vector2f position, Vector2f dimension);

	public void createTexture(Texture tex);

	public List<ShaderVariable<?>> getShaderUniforms(ShaderProgram prog);

	public List<ShaderVariable<?>> getShaderAttributes(ShaderProgram prog);

	public void createMipmap(Mipmap mipmap);

	public void createVertexBufferObject(AcceleratedArray<?> geometry);

	public void createShaderObject(ShaderObject obj);

	public void createShaderProgram(ShaderProgram prog);
}
