/*
 * Copyright (c) 2004-2006, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 * 
 */
package com.volatileengine.platform;

import java.util.ArrayList;
import java.util.List;

import javax.vecmath.Vector2f;

import com.volatileengine.scene.Frustum;
import com.volatileengine.scene.SceneMesh;
import com.volatileengine.scene.SceneObject;
import com.volatileengine.scene.Surface;

/**
 * @author Administrator
 * 
 */
public class RenderingContext {
	// channel
	private GPUChannel channel;

	// data needed for Context operation
	private Frustum frustum;
	private Surface[] surfaces;

	// temporary draw commands
	public RenderingContext(Surface... surfaces) {
		channel = new GPUChannel();
		this.surfaces = surfaces;
		// establish channel
		PlatformManager.instance().openChannel(channel);
	}

	public void viewport(Vector2f position, Vector2f dimension) {
		ViewportDrawCommand command = new ViewportDrawCommand(position, dimension);
		channel.put(command);
	}

	public void clear(Vector2f position, Vector2f dimension) {
		ClearDrawCommand command = new ClearDrawCommand(position, dimension);
		channel.put(command);
	}

	public void project3D(Frustum frustum) {
		this.frustum = frustum;
		FrustumDrawCommand command = new FrustumDrawCommand(frustum);
		channel.put(command);
	}

	public void project2D(int left, int right, int bottom, int top) {
		OrthoModeDrawCommand command = new OrthoModeDrawCommand(left, right, bottom, top);
		channel.put(command);
	}

	public void project2D(int width, int height) {
		this.project2D(0, width, 0, height);
	}

	public void project2DCentre(int width, int height) {
		this.project2D(-width / 2, width / 2, -width / 2, width / 2);
	}

	public void draw(SceneObject object) {
		List<SceneMesh> list = new ArrayList<SceneMesh>();
		SceneMeshDrawCommand command = new SceneMeshDrawCommand(list);
		// force first cull check
		object.draw(list, frustum, null, 3);
		channel.put(command);
	}

	public void show() {
		channel.put(new PrepareSurfaceDrawCommand(surfaces));
		channel.sync();

		// we've unlocked here, add the prepare surfaces
		channel.put(new ShowSurfaceDrawCommand(surfaces));
	}

	public void dispose() {
		PlatformManager.instance().closeChannel(channel);
	}
}
