/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.volatileengine.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/**
 * 
 * @author Administrator
 */
public class ZipResourceFinder implements IResourceFinder {

	private ZipFile zip;

	public ZipResourceFinder(URL url) throws IOException {
		if (url == null) {
			throw new IOException("URL (" + url + ") is invalid");
		}

		try {
			File f = new File(url.toURI());
			zip = new ZipFile(f);
		} catch (URISyntaxException ex) {
		}
	}

	public InputStream findResource(String name) throws IOException {
		ZipEntry entry = zip.getEntry(name);
		return zip.getInputStream(entry);
	}

}
