/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.volatileengine.resources.references;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;

/**
 * 
 * @author Administrator
 */
public abstract class Handle<T> extends PhantomReference<T> {

	public enum HandleType {
		TEXTURE, MIPMAP, VERTEX_BUFFER_OBJECT, SHADER, SHADER_UNIFORM;
	}

	private T resource;
	private int id;

	public Handle(T resource, int id, ReferenceQueue<T> queue) {
		super(resource, queue);
		this.id = id;
		this.resource = resource;
	}

	public T getResource() {
		return resource;
	}

	public int getIdentity() {
		return id;
	}

	public abstract HandleType getHandleType();
}
