/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.volatileengine.scene;

import com.volatileengine.platform.RenderingContext;
import com.volatileengine.resources.references.Handle;

/**
 * 
 * @author Owner
 */
public class CompositeSurface extends Surface {

	private Surface[] surfaces;

	public CompositeSurface(Surface... surf) {
		this.surfaces = surf;

		for (int i = 0; i < surfaces.length; i++) {
			switch (surfaces[i].getSurfaceCapability()) {
			case NONE:
				throw new IllegalArgumentException(
						"Cannot add a surface with no capability (e.g. WindowSurface) to a CompositeSurface");
			case MULTIPLE:
				Surface[] othrSurfaces = ((CompositeSurface) surfaces[i]).surfaces;
				surfaces = new Surface[surf.length + othrSurfaces.length];
				System.arraycopy(surf, 0, surfaces, 0, surf.length);
				System.arraycopy(((CompositeSurface) surfaces[i]).surfaces, 0, surfaces, surf.length,
						othrSurfaces.length);
			}
		}
	}

	@Override
	public SurfaceCapability getSurfaceCapability() {
		return SurfaceCapability.MULTIPLE;
	}

	@Override
	public RenderingContext getGraphicsContext() {
		return new RenderingContext(surfaces);
	}

	public Handle<?> getHandle() {
		return null;
	}

	public void setIdentity(Object id) {
		throw new UnsupportedOperationException("Not supported in CompositeSurface");
	}

	@Override
	public int getWidth() {
		throw new UnsupportedOperationException("Not supported in CompositeSurface");
	}

	@Override
	public int getHeight() {
		throw new UnsupportedOperationException("Not supported in CompositeSurface");
	}
}
