/*
 * Copyright (c) 2004-2006, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 * 
 */
package com.volatileengine.scene;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

import com.volatileengine.datatypes.ArrayFloat;

/**
 * @author Administrator
 * 
 */
public class Container {

	private float radius;
	private Point3f centre;

	public void computeFromData(ArrayFloat vertices) {
		if (vertices.getChunkSize() < 3 || vertices.getChunkSize() > 4) {
			throw new IllegalArgumentException("ChunkSize of vertices cannot be less than 3 or more than 4");
		}

		Vector3f scratch1 = new Vector3f();
		int vertQuantity = vertices.getLength();
		centre = new Point3f();
		for (int i = vertQuantity; --i >= 0;) {
			centre.add(vertices.getTuple3f(i, 0, scratch1));
		}
		centre.scale(1f / vertQuantity);

		radius = 0.0f;
		for (int i = vertQuantity; --i >= 0;) {
			vertices.getTuple3f(i, 0, scratch1).sub(centre);
			if (scratch1.lengthSquared() > radius) {
				radius = scratch1.lengthSquared();
			}
		}
		radius = (float) Math.sqrt(radius);
	}

	public Point3f getCentre() {
		return centre;
	}

	public float getRadius() {
		return radius;
	}

}
