/*
 * Copyright (c) 2004-2005, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
package com.volatileengine.scene;

import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;

import com.volatileengine.datatypes.AbstractArray;

/**
 * @author Ahmed
 * 
 */
public abstract class Geometry {

	public enum GeometryType {
		TRIANGLE, QUAD, POINT, LINE;
	}

	protected GeometryType geometryType = GeometryType.TRIANGLE;

	public GeometryType getGeometryType() {
		return geometryType;
	}

	public void setGeometryType(GeometryType geometryType) {
		this.geometryType = geometryType;
	}

	public int getVertexQuantity() {
		return getVertices().getLength();
	}

	public int getTextureCoordQuantity() {
		AbstractArray<?>[] texturecoords = getTextureCoordinates();
		return texturecoords != null ? texturecoords.length : 0;
	}

	protected void setupGeometry(Point3f[] vertices, Vector3f[] normals, Color4f[] colours,
			Vector2f[][] textureCoordinates, int[] indices) {
		// fill the data
		for (int i = 0; i < vertices.length; i++) {
			// vertices
			getVertices().setTuple3f(i, 0, vertices[i]);
			// normals
			if (getNormals() != null) {
				getNormals().setTuple3f(i, 0, normals[i]);
			}
			// colours
			if (getColours() != null) {
				getColours().setColor4f(i, 0, colours[i]);
			}
			// textures
			if (getTextureCoordinates() != null) {
				for (int j = 0; j < getTextureCoordinates().length; j++) {
					getTextureCoordinates()[j].setTuple2f(i, 0, textureCoordinates[j][i]);
				}
			}
		}

		for (int i = 0; i < indices.length; i++) {
			getIndices().setInt(i, 0, indices[i]);
		}

		getVertices().getBuffer().rewind();

		if (getNormals() != null) {
			getNormals().getBuffer().rewind();
		}

		if (getColours() != null) {
			getColours().getBuffer().rewind();
		}

		if (getTextureCoordinates() != null) {
			for (int i = 0; i < getTextureCoordinates().length; i++) {
				getTextureCoordinates()[i].getBuffer().rewind();
			}
		}

		getIndices().getBuffer().rewind();
	}

	public abstract AbstractArray<?> getVertices();

	public abstract AbstractArray<?> getNormals();

	public abstract AbstractArray<?> getColours();

	public abstract AbstractArray<?>[] getTextureCoordinates();

	public abstract AbstractArray<?> getIndices();

}
