package org.wggds.webservices.io.data;

import org.wggds.webservices.io.WggdsQueryExcpetion;

public enum ListOperation
{
    AND("AND"),
    OR("OR"),
    NOT("NOT"),
    NAND("NAND"),
    NOR("NOR"),
    XOR("XOR");

    private String m_operation = null;

    private ListOperation(String a_operation)
    {
        this.m_operation = a_operation;
    }

    public static ListOperation forOperation( String a_operation) throws WggdsQueryExcpetion
    {
        for ( ListOperation a : ListOperation.values() )
        {
            if ( a_operation.equalsIgnoreCase(a.m_operation) )
            {
                return a;
            }
        }
        throw new WggdsQueryExcpetion("Unknown operation: " + a_operation);
    }
    
    public String getOperation()
    {
        return this.m_operation;
    }
}
