package org.wggds.webservices.io.data;

import org.wggds.webservices.io.WggdsQueryExcpetion;

public enum OutputFormat
{
    XML("xml"),
    JSON("json");

    private String m_format = null;

    private OutputFormat(String a_format)
    {
        this.m_format = a_format;
    }

    public static OutputFormat forFormat( String a_format) throws WggdsQueryExcpetion
    {
        for ( OutputFormat a : OutputFormat.values() )
        {
            if ( a_format.equals(a.m_format) )
            {
                return a;
            }
        }
        throw new WggdsQueryExcpetion("Unknown output format: " + a_format);
    }

    public String getFormat()
    {
        return m_format;
    }

}
