package DBLayer;

import java.sql.*;
import java.util.ArrayList;
import ModelLayer.Clothing;
import ModelLayer.Supplier;

public class DBClothing implements IFClothing {
	
	private Connection con;
	
	// constructor makes new database connection on object creation.
	public DBClothing() {
		con = DBConnection.getInstance().getDBCon();
	}

	@Override
	// returns array list of all Clothing, wClause is empty means no 'where' is used, see buildQuery()
	public ArrayList<Clothing> getAllClothing(boolean retrieveAssociation) {
		return miscWhere("", retrieveAssociation);
	}

	// returns single Clothing, ProductID is used for wClause see buildQuery()
	@Override
	public Clothing findClothing(int productID, boolean retrieveAssociation) {
		String wClause = " ProductID = '" + productID + "'";
		return singleWhere(wClause, retrieveAssociation);
	}

	// returns Clothing which name matches the pattern
	@Override
	public Clothing searchClothingByName(String name, boolean retrieveAssociation) {
		String wClause = "Name like '%" + name + "%'";
		System.out.println("SearchClothng " + wClause);
		return singleWhere(wClause, retrieveAssociation);
	}

	// insert object fields into database
	@Override
	public int insert(Clothing clo) throws Exception {
		// Max only for productID from CLOTHING, EQUIPMENT, GUNREPOLICAS
		int nextProductID = GetMax.getMaxProductID();
		// next one that's going to be used
		nextProductID = nextProductID + 1;
		System.out.println("Next ProductID = " + nextProductID);
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that return nothing 
		int rc = -1;
		
		// constructing query
		String query = "insert into CLOTHING(ProductID, Name, PurchasePrice, RentPrice, CountryOfOrigin, MinStock, Size, Color, SupplierName ) values(" +
				nextProductID + ",'"  +
				clo.getName() + "'," +
				clo.getPurchasePrice() + "," +
				clo.getRentPrice() + ",'" +
				clo.getCountryOfOrigin() + "'," +
				clo.getMinStock() + "," +
				clo.getSize() + ",'" + 
				clo.getColour() + "','" +
				clo.getSupplier().getName() + "');";
				//clo.getColour() + "'";
		System.out.println("Insert query : " + query);
		
		// creating statement and executing query
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Clothing was not put into database");
			e.getMessage();
			throw new Exception ("Error while entering Clothing data into database");
		}
		return rc;
	}

	// update fields in database
	@Override
	public int update(Clothing clo) {
		Clothing cloObj = clo;
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that return nothing
		int rc = -1;
		
		// constructing query
		String query = "update CLOTHING set " +
				// "ProductID = " + cloObj.getProductID() + "," + 
				"Name = '" + cloObj.getName() + "'," +
				"PurchasePrice = " + cloObj.getPurchasePrice() + "," +
				"RentPrice = " + cloObj.getRentPrice() + "," + 
				"CountryOfOrigin = '" + cloObj.getCountryOfOrigin() + "'," +
				"MinStock = " + cloObj.getMinStock() + "," +
				"Size = " + cloObj.getSize() + "," +
				"Color = '" + cloObj.getColour() + "'," +
				"SupplierName = '" + cloObj.getSupplier().getName() + "' " +
				"where ProductID = " + cloObj.getProductID() + ";";
		System.out.println("Update query : " + query);
		
		// creating statement and executing query
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Clothing was not updated");
			e.getMessage();
		}
		return rc;
	}

	@Override
	public int delete(int productID) {
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that return nothing
		int rc = -1;
		
		// constructing query
		String query = "delete from CLOTHING where ProductID = " + productID + ";" ;
		System.out.println("Delete query : " + query);
		
		// creating statement and executing query
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Clothing was not deleted");
			e.getMessage();
		}
		return rc;
	}
	
	// private methods
	
	// sigleWhere used when only one Clothing object is to be built
	private Clothing singleWhere(String wClause, boolean retrieveAssociation) {
		ResultSet results;
		Clothing cloObj = new Clothing();
		
		String query = buildQuery(wClause);
		System.out.println(query);
		
		// try reading Clothing from database
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			
			if (results.next()) {
				cloObj = buildClothing(results);
				stmt.close();
				// if the boolean value is true 
				if (retrieveAssociation) {
					// look at DBEmployee.java, DBWorksON.java is better example
					IFSupplier dbSupplier = new DBSupplier();
					String suppName = cloObj.getSupplier().getName();
					Supplier supp = dbSupplier.searchSupplierByName(suppName, false);
					cloObj.setSupplier(supp);
				}
			} else {
				// no Clothing was found
				cloObj = null;
			}
		} catch (Exception e) {
			System.out.println("Query exception: ");
			e.getMessage();
		}
		return cloObj;
	}
	
	// miscWhere used when more than one Clothing is selected and built
	private ArrayList<Clothing> miscWhere(String wClause, boolean retrieveAssociation) {
		// preparing objects that are going to be used
		ResultSet results;
		ArrayList<Clothing> list = new ArrayList<Clothing>();
		
		String query = buildQuery(wClause);
		
		// try to get multiple rows and store it in ArrayList of Clothing object 
		try {
			// getting all the results, based on query
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			// creating each object and adding them to the list 
			while (results.next()) {
				Clothing cloObj = new Clothing();
				cloObj = buildClothing(results);
				list.add(cloObj);
			}
			// done with the statement
			stmt.close();
			if (retrieveAssociation) {
				IFSupplier dbSupplier = new DBSupplier();
				for (Clothing clo : list) {
					String suppName = clo.getSupplier().getName();
					Supplier supp = dbSupplier.searchSupplierByName(suppName, false);
					clo.setSupplier(supp);
				}
			}
		} catch (Exception e) {
			System.out.println("Query exception - select: "+e);
			e.getMessage();
		}
		return list;
	}
	
	// build Clothing object out of data fetched from database
	private Clothing buildClothing(ResultSet results) {
		Supplier supp = new Supplier();
		Clothing cloObj = new Clothing();
		// make reference to supplier
		cloObj.setSupplier(supp);
		// try to fill clothing object fields with data from database
		try {
			cloObj.setProductID(results.getInt("ProductID"));
			cloObj.setName(results.getString("Name"));
			cloObj.setPurchasePrice(results.getInt("PurchasePrice"));
			cloObj.setRentPrice(results.getInt("RentPrice"));
			cloObj.setCountryOfOrigin(results.getString("CountryOfOrigin"));
			cloObj.setMinStock(results.getInt("MinStock"));
			cloObj.setSize(results.getInt("Size"));
			cloObj.setColour(results.getString("Color"));
			supp.setName(results.getString("SupplierName"));
		} catch (Exception e) {
			System.out.println("error in building the Clothing object");
			e.getMessage();
		}	
		return cloObj;
	}
	
	// method to build query, unchanged from CompanyCode example, needs to be changed
	private String buildQuery(String wClause) {
		String query="select * from CLOTHING";
		
		if (wClause.length()>0)
			query=query+" where "+ wClause;
			
		return query;
	}
}
