package DBLayer;

import java.sql.*;
import java.util.ArrayList;

import ModelLayer.*;

public class DBClothingSaleLine implements IFClothingSaleLine {

	private Connection con;
	
	public DBClothingSaleLine() {
		con = DBConnection.getInstance().getDBCon();
	}
	
	@Override
	public ArrayList<SaleLine> getAllClothingSaleLines(boolean retrieveAssociation) {
		return miscWhere("", retrieveAssociation);
	}
	
	@Override
	//builds a list of all saleLines that are found by orderID; 
	public ArrayList<SaleLine> getAllLinesByOrderID(int orderID, boolean retrieveAssociation) {
		String wClause = " OrderID = '" + orderID + "'";	
		return miscWhere(wClause, retrieveAssociation);
		
	}
	
	@Override
	public SaleLine findClothingSaleLine(int productID, boolean retrieveAssociation) {
		String wClause = " ProductID = '" + productID + "'";
		return singleWhere(wClause, retrieveAssociation);
	}

	@Override
	public int insert(SaleLine cloSale) throws Exception {
		int rc = -1;
		String query = "insert into CLOTHING_SALE_LINE(OrderID, ProductID, Quantity) values (" +
				// cloSale.getProductID() + "'," +
				cloSale.getSalesOrder().getOrderID() + "," +
				cloSale.getProduct().getProductID() + "," +
				cloSale.getQuantity() + ");";
		System.out.println("Insert query : " + query);
		
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		}
		catch (Exception e) {
			System.out.println("Clothing sale line was not put into database");
			e.getMessage();
			throw new Exception ("Error while entering Clothing sale line into database");
		}
		return rc;
		
	}

	@Override
	public int update(SaleLine cloSale) {
		SaleLine cloSaleObj = cloSale;
		int rc = -1;
		String query = "update CLOTHING_SALE_LINE set " +
				"OrderID = " + cloSaleObj.getSalesOrder().getOrderID() + "," +
				"ProductID = " + cloSaleObj.getProduct().getProductID() + "," + 
				"Quantity = '" + cloSaleObj.getQuantity() + ";" ;
		System.out.println("Update query : " + query);
		
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Clothing sale line was not updated");
			e.getMessage();
		}
		return rc;
	}

	@Override
	public int delete(int productID) {
		int rc = -1;
		String query = "delete from CLOTHING_SALE_LINE where ProductID = " + productID + ";" ;
		System.out.println("Delete query : " + query);
		
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} 
		catch (Exception e) {
			System.out.println("Clothing sale line was not deleted");
			e.getMessage();
		}
		return rc;
	}
	
	// used when only one SaleLine object is to be built
	private SaleLine singleWhere(String wClause, boolean retrieveAssociation) {
			
		ResultSet results;
		SaleLine saleLineObj = new SaleLine();
		String query = buildQuery(wClause);
		System.out.println(query);
			
		// try reading SaleLine from database
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			if (results.next()) {
				saleLineObj = buildSaleLine(results);
				stmt.close();
				if (retrieveAssociation) {
					IFSalesOrder dbSalesOrder = new DBSalesOrder();
					int salesOrderID = saleLineObj.getSalesOrder().getOrderID();
					SalesOrder salesOrder = dbSalesOrder.findSalesOrder(salesOrderID, false);
					saleLineObj.setSalesOrder(salesOrder);
					
					IFClothing dbClothing = new DBClothing();
					int clothingID = saleLineObj.getProduct().getProductID();
					Clothing clothing = dbClothing.findClothing(clothingID, false);
					saleLineObj.setProduct(clothing);
				}
			}	
		} 
		catch (Exception e) {
				System.out.println("Query exception: "+e);
				e.getMessage();
			}
			return saleLineObj;
		}
		
	// used when more than one SaleLine is created
	private ArrayList<SaleLine> miscWhere(String wClause, boolean retrieveAssociation) {
		ResultSet results;
		ArrayList<SaleLine> list = new ArrayList<SaleLine>();
		String query = buildQuery(wClause);
			
		// try to get multiple rows and store them in an ArrayList of SaleLine object 
		try {
			// getting all the results, based on the query
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			// create each SaleLine object and add it to the list 
			while (results.next()) {
				SaleLine saleLineObj = new SaleLine();
				saleLineObj = buildSaleLine(results);
				list.add(saleLineObj);
			}
			stmt.close();
			if (retrieveAssociation) {
				IFSalesOrder dbSalesOrder = new DBSalesOrder();
				IFClothing dbClothing = new DBClothing();
				for (SaleLine saleLine : list) {
					int salesOrderID = saleLine.getSalesOrder().getOrderID();
					SalesOrder salesOrder = dbSalesOrder.findSalesOrder(salesOrderID, false);
					saleLine.setSalesOrder(salesOrder);
					
					int clothingID = saleLine.getProduct().getProductID();
					Clothing clothing = dbClothing.findClothing(clothingID, false);
					saleLine.setProduct(clothing);
				}
			}
		} 
		catch (Exception e) {
			System.out.println("Query exception - select: "+e);
			e.getMessage();
		}
		return list;
	}
		
	// build SaleLine object out of data fetched from database
	private SaleLine buildSaleLine(ResultSet results) {
		// create objects that will be referenced
		Clothing clothing = new Clothing();
		SalesOrder salesOrder = new SalesOrder();
		// create SaleLine object
		SaleLine saleLineObj = new SaleLine();
		// references to Product and SalesOrder objects
		saleLineObj.setProduct(clothing);
		saleLineObj.setSalesOrder(salesOrder);
		// try to fill SaleLine object fields with data from database
		try {
			clothing.setProductID(results.getInt("ProductID"));
			salesOrder.setOrderID(results.getInt("OrderID"));
			saleLineObj.setQuantity(results.getInt("Quantity"));
		} 
		catch (Exception e) {
			System.out.println("Error in building the SaleLine object");
			e.getMessage();
		}	
		return saleLineObj;
	}
		
	private String buildQuery(String wClause) {
		String query="select * from CLOTHING_SALE_LINE";
			
		if (wClause.length()>0)
			query=query+" where "+ wClause;
				
		return query;
		}
}
