package DBLayer;

import java.sql.*;

public class DBConnection {

	// connection data, have to be changed! all of them. taken from company example
	private static final String driver = "jdbc:sqlserver://balder.ucn.dk";
	private static final String  databaseName = ";databaseName=dmae0912_3";
    private static String  userName = "; user=dmae0912_3";
    private static String password = ";password=IsAllowed";
    
    private DatabaseMetaData dma;
    private static Connection con;
    // an instance of the class is generated
    private static DBConnection  instance = null;
    
    // private constructor, only one instance can be created, for singleton
    private DBConnection() {
    	
    	String url = driver + databaseName + userName + password;
        try {
            //load driver
            //SQL Server
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            System.out.println("Load of class ok");
        } catch (Exception e) {
            System.out.println("Can not find the driver");
            System.out.println(e.getMessage());
        	}
        
        try {
            //connection to the database
            con = DriverManager.getConnection(url);
            //set autocommit
            con.setAutoCommit(true);
            dma = con.getMetaData(); // get meta data
            System.out.println("Connection to " + dma.getURL());
            System.out.println("Driver " + dma.getDriverName());
            System.out.println("Database product name " + dma.getDatabaseProductName());
        } catch (Exception e) {
            System.out.println("Problems with the connection to the database");
            System.out.println(e.getMessage());
            System.out.println(url);
        	}
    }
    
    // get the only existing instance of the class, singleton
    public static DBConnection getInstance() {
        if (instance == null) {
          instance = new DBConnection();
        }
        return instance;
    }
    
    //getDBCon: Get-method, returns the database connection
    public  Connection getDBCon() {
       return con;
    }
    
    public static void closeConnection() {
       	try {
            con.close();
            System.out.println("The connection is closed");
        } catch (Exception e) {
            System.out.println("Error trying to close the database connection " +  e.getMessage());
         	}
    }
    
    public static void startTransaction() {
    	try {
    		con.setAutoCommit(false);
        } catch (Exception e) {
        	System.out.println("failed to start transaction");
        	System.out.println(e.getMessage());
          	}
    }
    
    public static void commitTransaction() { 
    	try{
    		con.setAutoCommit(true);
        } catch(Exception e) {
        	System.out.println("failed to commit transaction");
        	System.out.println(e.getMessage());
        	}
    }
    
    public static void rollbackTransaction() { 
    	try {
    		con.rollback();
    		con.setAutoCommit(true);
        } catch(Exception e) {
        	System.out.println("failed to rollback transaction");
        	System.out.println(e.getMessage());
        	}
    }
}
