package DBLayer;

import java.sql.*;
import java.util.ArrayList;
import ModelLayer.*;

public class DBCustomer implements IFCustomer {
	
	private Connection con;
	
	// constructor makes new database connection on object creation.
	public DBCustomer() {
		con = DBConnection.getInstance().getDBCon();
	}
	
	@Override
	// returns array list of all Clothing, wClause is empty means no 'where' is used, see buildQuery()
	public ArrayList<Customer> getAllCustomers(boolean retrieveAssociation) {
		return miscWhere("", retrieveAssociation);
	}
	
	// returns single Clothing, ProductID is used for wClause see buildQuery()
	@Override
	public Customer findCustomer(String cPR, boolean retrieveAssociation) {
		String wClause = " cPR = '" + cPR + "'";
		return singleWhere(wClause, retrieveAssociation);
	}

	// returns Clothing which name matches the pattern
	@Override
	public Customer searchCustomerByName(String name, boolean retrieveAssociation) {
		String wClause = "Name like '%" + name + "%'";
		System.out.println("SearchCustomer " + wClause);
		return singleWhere(wClause, retrieveAssociation);
	}
	
	// insert object fields into database
	@Override
	public int insert(Customer cus) {
		
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that returns nothing 
		int rc = -1;
		
		// constructing query
		String query = "insert into CUSTOMER(Address, cPR, Name, PhoneNo, ZipCode) values('" +
				cus.getAddress() + "'," +
				cus.getCPR() + ",'" +
				cus.getName() + "'," +
				cus.getPhoneNo() + "'," +
				cus.getLocation().getZipCode() + ");";
		System.out.println("Insert query : " + query);
		
		// creating statement and executing query
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Customer was not put into the database");
			e.getMessage();
		}
		return rc;
	}
	
	// update fields in database
	@Override
	public int update(Customer cus) {
		
		Customer cusObj = cus;
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that returns nothing
		int rc = -1;
		
		// constructing query
		String query = "update CUSTOMER set " +
				"Address = '" + cusObj.getAddress() + "'," +
				"Name = '" + cusObj.getName() + "'," +
				"PhoneNo = '" + cusObj.getPhoneNo() + "'," +
				"ZipCode = " + cusObj.getLocation().getZipCode() + " " +
				"where cPR = " + cusObj.getCPR() + ";";
		System.out.println("Update query : " + query);
		
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Customer was not updated");
			e.getMessage();
		}
		return rc;
	}
	
	@Override
	public int delete(String cPR) {
		
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that returns nothing
		int rc = -1;
		
		// constructing query
		String query = "delete from CUSTOMER where cPR = " + cPR + ";";
		System.out.println("Delete query : " + query);
		
		// creating statement and executing query
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Customer was not deleted");
			e.getMessage();
		}
		
		return rc;
	}
	
	// private methods
	
	// sigleWhere used when only one Clothing object is to be built
	private Customer singleWhere(String wClause, boolean retrieveAssociation) {
		ResultSet results;
		Customer cusObj = new Customer();
		
		String query = buildQuery(wClause);
		System.out.println(query);
		
		// try reading Clothing from database
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			
			if (results.next()) {
				cusObj = buildCustomer(results);
				stmt.close();
				// if the boolean value is true 
				if (retrieveAssociation) {	
					IFLocation dbLocation = new DBLocation();
					int locZipCode = cusObj.getLocation().getZipCode();
					Location loc = dbLocation.findLocation(locZipCode, false);
					cusObj.setLocation(loc);
			}
		} else {
			// no Customer was found
			cusObj = null;
		}
	} catch (Exception e) {
		System.out.println("Query exception: "+e);
		e.getMessage();
	
	}
		
		return cusObj;
		
	}
	
	// miscWhere used when more than one Customer is selected and built
	private ArrayList<Customer> miscWhere(String wClause, boolean retrieveAssociation) {
		// preparing objects that are going to be used
		ResultSet results;
		ArrayList<Customer> list = new ArrayList<Customer>();
		
		String query= buildQuery(wClause);
		
		// try to get multiple rows and store it in ArrayList of Clothing object 
		try{
			// getting all the results, based on query
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			// creating each object and adding them to the list
			while (results.next()) {
				Customer cusObj = new Customer();
				cusObj = buildCustomer(results);
				list.add(cusObj);
			}
			// done with the statement
			stmt.close();
			if (retrieveAssociation) {
				IFLocation dbLocation = new DBLocation();
				for (Customer cus : list) {
					int locZipCode = cus.getLocation().getZipCode();
					Location loc = dbLocation.findLocation(locZipCode, false);
					cus.setLocation(loc);
				}
			}
		} catch (Exception e) {
			System.out.println("Query exception - select: "+e);
			e.getMessage();
		}
		return null;
	}
	
	// build Customer object out of data fetched from database
	private Customer buildCustomer(ResultSet results) {
		Location loc = new Location();
		Customer cusObj = new Customer();
		// make reference to location
		cusObj.setLocation(loc);
		// try to fill Customer object fields with data from database
		try {
			cusObj.setName(results.getString("Name"));
			cusObj.setCPR(results.getString("cPR"));
			cusObj.setAddress(results.getString("Address"));
			// there is no city column
			// cusObj.setCity(results.getString("City"));
			cusObj.setPhoneNo(results.getString("PhoneNo"));
			loc.setZipCode(results.getInt("ZipCode"));
		} catch (Exception e) {
			System.out.println("error in building the Customer object");
			e.getMessage();
		}
		return cusObj;
	}
	
	// method to build query
	private String buildQuery(String wClause) {
		
		String query="select * from CUSTOMER";
		
		if (wClause.length()>0)
			query=query+" where "+ wClause;
		
		return query;
		
	}

}
