package DBLayer;

import java.sql.*;
import java.util.ArrayList;

import ModelLayer.*;

public class DBGunReplicas implements IFGunReplicas {

	private Connection con;
	
	// constructor 
	public DBGunReplicas() {
		con = DBConnection.getInstance().getDBCon();
	}
	
	// get an ArrayList of all GunReplicas
	@Override
	public ArrayList<GunReplicas> getAllGunReplicas(boolean retrieveAssociation) {
		return miscWhere("", retrieveAssociation);
	}

	// find single GunReplica
	@Override
	public GunReplicas findGunReplica(int productID, boolean retrieveAssociation) {
		String wClause = " ProductID = '" + productID + "'";
		return singleWhere(wClause, retrieveAssociation);
	}

	// search GunReplicas whose name matches the pattern
	@Override
	public GunReplicas searchGunReplicaByName(String name, boolean retrieveAssociation) {
		String wClause = "Name like '%" + name + "%'";
		System.out.println("SearchGunReplica " + wClause);
		return singleWhere(wClause, retrieveAssociation);
	}

	// insert object fields into database
	@Override
	public int insert(GunReplicas gun) throws Exception{
		int nextProductID = GetMax.getMaxProductID();
		nextProductID = nextProductID + 1;
		System.out.println("Next ProductID = " + nextProductID);
		int rc = -1;
				
		String query = "insert into GUNREPLICAS(ProductID, Name, PurchasePrice, RentPrice, CountryOfOrigin, MinStock, Fabric, Calibre) values(" +
				nextProductID + ",'"  +
				gun.getName() + "'," +
				gun.getPurchasePrice() + "," +
				gun.getRentPrice() + ",'" +
				gun.getCountryOfOrigin() + "'," +
				gun.getMinStock() + "," +
				gun.getFabric() + ",'" + 
				gun.getCalibre() + "'" +
				gun.getSupplier().getName() + "'):";
		System.out.println("Insert query : " + query);
				
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Gun replica was not put into database");
			e.getMessage();
			throw new Exception ("Error while entering Gun replica data into database");
		}
		return rc;
	}

	// update fields in database
	@Override
	public int update(GunReplicas gun) {
		GunReplicas gunObj = gun;
		int rc = -1;
		
		String query = "update GUNREPLICAS set" +
				// "ProductID = " + gunObj.getProductID() + "," + 
				"Name = '" + gunObj.getName() + "'," +
				"PurchasePrice = " + gunObj.getPurchasePrice() + "," +
				"RentPrice = " + gunObj.getRentPrice() + "," + 
				"CountryOfOrigin = '" + gunObj.getCountryOfOrigin() + "'," +
				"MinStock = " + gunObj.getMinStock() + "," +
				"Fabric = " + gunObj.getFabric() + "," +
				"Calibre = '" + gunObj.getCalibre() + "'" +
				"SupplierName = '" + gunObj.getSupplier().getName() + "'" +
				"where ProductID = " + gunObj.getProductID() + ";";
		System.out.println("Update query : " + query);
		
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Gun replica was not updated");
			e.getMessage();
		}
		return rc;
	}

	// delete object fields from database
	@Override
	public int delete(int productID) {
		int rc = -1;
		
		String query = "delete from GUNREPLICAS where ProductID = " + productID + ";" ;
		System.out.println("Delete query : " + query);
		
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Gun replica was not deleted");
			e.getMessage();
		}
		return rc;
	}

	// used when creating only one GunReplicas object
	private GunReplicas singleWhere(String wClause, boolean retrieveAssociation) {
		ResultSet results;
		GunReplicas gunObj = new GunReplicas();
		String query = buildQuery(wClause);
		System.out.println(query);
			
		// try reading GunReplicas from database
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
				
			if (results.next()) {
				gunObj = buildGunReplicas(results);
				stmt.close();
				if (retrieveAssociation) {
					IFSupplier dbSupplier = new DBSupplier();
					String suppName = gunObj.getSupplier().getName();
					Supplier supp = dbSupplier.searchSupplierByName(suppName, false);
					gunObj.setSupplier(supp);	
				}
			} else {
				// no Gun was found
				gunObj = null;
			}
		}
		catch (Exception e) {
			System.out.println("Query exception: "+e);
			e.getMessage();
		}
		return gunObj;
	}

	// used when creating more than one GunReplicas object
	private ArrayList<GunReplicas> miscWhere(String wClause, boolean retrieveAssociation) {
		ResultSet results;
		ArrayList<GunReplicas> list = new ArrayList<GunReplicas>();
		String query = buildQuery(wClause);
			
		// try to get multiple rows and store them in ArrayList of Equipment object
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			// create each object and add it to the list
			while (results.next()) {
				GunReplicas gunObj = new GunReplicas();
				gunObj = buildGunReplicas(results);
				list.add(gunObj);
			}
			stmt.close();
			if (retrieveAssociation) {
				IFSupplier dbSupplier = new DBSupplier();
				for (GunReplicas gun : list) {
					String suppName = gun.getSupplier().getName();
					Supplier supp = dbSupplier.searchSupplierByName(suppName, false);
					gun.setSupplier(supp);
				}
		}
	}
		catch (Exception e) {
			System.out.println("Query exception - select: "+e);
			e.getMessage();
		}
		return list;
}

	// build GunReplicas object out of data fetched from database
	private GunReplicas buildGunReplicas(ResultSet results) {
		GunReplicas gunObj = new GunReplicas();
		// try to fill GunReplicas object fields with data from database
		try {
			gunObj.setProductID(results.getInt("ProductID"));
			gunObj.setName(results.getString("Name"));
			gunObj.setPurchasePrice(results.getInt("PurchasePrice"));
			gunObj.setRentPrice(results.getInt("RentPrice"));
			gunObj.setCountryOfOrigin(results.getString("CountryOfOrigin"));
			gunObj.setMinStock(results.getInt("MinStock"));
			gunObj.setFabric(results.getString("Fabric"));
			gunObj.setCalibre(results.getString("Calibre"));
			}
		catch (Exception e) {
			System.out.println("Error in building the GunReplicas object");
			e.getMessage();
		}
		return gunObj;
	}

	private String buildQuery(String wClause) {
		String query = "SELECT * FROM GUNREPLICAS";
		if (wClause.length()>0)
			query = query+" WHERE "+ wClause;
		return query;
	}
}
