package DBLayer;

import java.sql.*;
import java.util.ArrayList;
import ModelLayer.Location;

public class DBLocation implements IFLocation {
	
	private Connection con;
	
	// constructor makes new database connection on object creation.
	public DBLocation() {
		con = DBConnection.getInstance().getDBCon();
	}

	@Override
	// returns array list of all Clothing, wClause is empty means no 'where' is used, see buildQuery()
	public ArrayList<Location> getAllLocation(boolean retrieveAssociation) {
		return miscWhere("", retrieveAssociation);
	}

	// returns single Clothing, ProductID is used for wClause see buildQuery()
	@Override
	public Location findLocation(int zipCode, boolean retrieveAssociation) {
		String wClause = " ZipCode = '" + zipCode + "'";
		return singleWhere(wClause, retrieveAssociation);
	}

	// returns Clothing which name matches the pattern
	@Override
	public Location searchLocationByCity(String city, boolean retrieveAssociation) {
		String wClause = "City like '%" + city + "%'";
		System.out.println("SearchLocation " + wClause);
		return singleWhere(wClause, retrieveAssociation);
	}

	// insert object fields into database
	@Override
	public int insert(Location loc) {
		
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that returns nothing 
		int rc = -1;
		
		String query = "insert into LOCATION (ZipCode, City, Country) values(" +
				loc.getZipCode() + ",'" +
				loc.getCity() + "','" +
				loc.getCountry() + "');";
		System.out.println("Insert query : " + query);
		
		// creating statement and executing query
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Location was not put into the database");
			e.getMessage();
		}
		return rc;
	}

	// update fields in database
	@Override
	public int update(Location loc) {
		
		Location locObj = loc;
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that returns nothing
		int rc = -1;
		
		// constructing query
		String query = "update LOCATION set " +
				"ZipCode = " + locObj.getZipCode() + "," +
				"City = '" + locObj.getCity() + "'," +
				"Country = '" + locObj.getCountry() + "'," +
				"Where ZipCode = " + locObj.getZipCode() + ";";
		System.out.println("Update query : " + query);
		
		// creating statement and executing query
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Location was not updated");
			e.getMessage();
		}
		return rc;
	}

	@Override
	public int delete(int ZipCode) {
		
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that returns nothing
		int rc = -1;
		
		// constructing query
		String query = "delete from LOCATION where ZipCode = " + ZipCode + ";";
		System.out.println("Delete query : " + query);
		
		// creating statement and executing query
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc=stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Location was not deleted");
			e.getMessage();
		}
		return rc;
	}
	
	// private methods

	// sigleWhere used when only one Clothing object is to be built
	private Location singleWhere(String wClause, boolean retrieveAssociation) {
		ResultSet results;
		Location locObj = new Location();
		
		String query = buildQuery(wClause);
		System.out.println(query);
		
		// try reading Clothing from database
		try{
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			
			if (results.next()) {
				locObj = buildLocation(results);
				stmt.close();
				// if the boolean value is true 
				if (retrieveAssociation) {
					// TODO
					// there are no associations
					return null;
			}
		}
	} catch (Exception e) {
		System.out.println("Query exception: "+e);
		e.getMessage();
		
	}
		return locObj;
	}
	
	// miscWhere used when more than one Location is selected and built
	private ArrayList<Location> miscWhere(String wClause, boolean retrieveAssociation) {
		// preparing objects that are going to be used
		ResultSet results;
		ArrayList<Location> list = new ArrayList<Location>();
		
		String query = buildQuery(wClause);
		
		// try to get multiple rows and store it in ArrayList of Clothing object 
		try {
			// getting all the results, based on query
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			// creating each object and adding them to the list
			while (results.next()) {
				Location locObj = new Location();
				locObj = buildLocation(results);
				list.add(locObj);
			}
			// done with the statement
			
			stmt.close();
			if (retrieveAssociation) {
				// TODO
				// there are no associations
			}
		} catch (Exception e) {
			System.out.println("Query exception - select: "+e);
			e.getMessage();
		}
		return list;
	}
	
	// build Location object out of data fetched from database
	private Location buildLocation(ResultSet results) {
		Location locObj = new Location();
		// try to fill Location object fields with data from database
		try {
			locObj.setCity(results.getString("City"));
			locObj.setZipCode(results.getInt("ZipCode"));
			locObj.setCountry(results.getString("Country"));
		} catch (Exception e) {
			System.out.println("error in building the Location object");
			e.getMessage();
		}
		return locObj;
	}
	
	// method to build query, unchanged from CompanyCode example, needs to be changed
	private String buildQuery(String wClause) {
		
		String query="select * from LOCATION";
		
		if (wClause.length()>0)
			query=query+" where "+ wClause;
		
		return query;
	}
}
