package DBLayer;

import ModelLayer.*;

import java.util.ArrayList;

public interface IFClothingSaleLine {
	
	// get all SaleLines of Clothing
    public ArrayList<SaleLine> getAllClothingSaleLines(boolean retrieveAssociation);
    
    // get all SaleLines found by orderID criteria
    public ArrayList<SaleLine> getAllLinesByOrderID(int orderID, boolean retrieveAssociation);
    
    // search Sale Lines of Clothing by ProductID    
    public SaleLine findClothingSaleLine(int ProductID, boolean retrieveAssociation);
    
    //insert new SaleLine of Clothing
    public int insert(SaleLine cloSale) throws Exception;
    
    //update SaleLine of Clothing
    public int update(SaleLine cloSale);
    
    //delete SaleLine of Clothing
    public int delete(int productID);
}
