package DBLayer;

import ModelLayer.*;

import java.util.ArrayList;

public interface IFEquipmentSaleLine {
	
	// get all SaleLines of Equipment
    public ArrayList<SaleLine> getAllEquipmentSaleLines(boolean retriveAssociation);
    
    // search Sale Lines of Equipment by ProductID    
    public SaleLine findEquipmentSaleLine(int ProductID, boolean retriveAssociation);
    
    // get all SaleLines found by orderID criteria
    public ArrayList<SaleLine> getAllLinesByOrderID(int orderID, boolean retrieveAssociation);
    
    //insert new SaleLine of Equipment
    public int insert(SaleLine equipSale)throws Exception;
    
    //update SaleLine of Equipment
    public int update(SaleLine equipSale);
    
    //delete SaleLine of Equipment
    public int delete(int productID);
}
