package DBLayer;

import ModelLayer.*;

import java.util.ArrayList;

public interface IFGunReplicasSaleLine {

	// get all SaleLines of GunReplicas
    public ArrayList<SaleLine> getAllGunReplicasSaleLines(boolean retriveAssociation);
    
    // search SaleLine of GunReplicas by ProductID    
    public SaleLine findGunReplicaSaleLine(int ProductID, boolean retriveAssociation);
    
    // get all SaleLines found by orderID criteria
    public ArrayList<SaleLine> getAllLinesByOrderID(int orderID, boolean retrieveAssociation);
    
    //insert new SaleLine of GunReplicas
    public int insert(SaleLine gunSale)throws Exception;
    
    //update SaleLine of GunReplicas
    public int update(SaleLine gunSale);
    
    //delete SaleLine of GunReplicas
    public int delete(int productID);
}
