package DBLayer;

import java.util.ArrayList;

import ModelLayer.Supplier;


public interface IFSupplier {
	// get all Suppliers
    public ArrayList<Supplier> getAllSupplier(boolean retrieveAssociation);
    //find one Supplier by the name 
    public Supplier searchSupplierByName(String name, boolean retrieveAssociation);
    // find supplier by e-mail
    public Supplier searchSupplierByEmail(String email, boolean retrieveAssociation);
    //insert new Supplier
    public int insert(Supplier sup) throws Exception;
    //update Supplier
    public int update(Supplier sup);
    //delete Supplier
	public int delete(String name);
}
