package GUILayer;

import java.awt.EventQueue;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import ControlLayer.OrderCtr;
import ModelLayer.SalesOrder;

import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JTextField;
import javax.swing.JLabel;

public class OrderGUI extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 70773229282060910L;
	private JPanel contentPane; //content pane
	private JTable table; // table for orders
	private OrderCtr ordCtr; // controller object
	ArrayList<SalesOrder> orders; // list of all orders
	private JScrollPane scrollPane; //pane needed for table
	private DefaultTableModel dtm; // model for table
	private JButton btnCreate; 
	private JButton btnDelete;
	private JButton btnEdit;
	private JButton btnPrintInvoice;//components
	private JTextField textField;
	private JButton btnNewButton;
	private JLabel lblId;
	private JButton btnShowAll;
	private DefaultComboBoxModel dcbm;//model for combo boxes needed for table field "status"
	private ArrayList<Integer> rows;//list of indexes of rows, which have been edited
	/**
	 * Launch the application.Create the Frame.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					OrderGUI frame = new OrderGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	@SuppressWarnings("serial")
	public OrderGUI() {
		
		rows = new ArrayList<Integer>(); 
		dcbm = new DefaultComboBoxModel<>(new String[]{"Delivered","Pending"});//set the default combo box model
		
		scrollPane = new JScrollPane();
		scrollPane.setBounds(16, 45, 588, 370);
		
		table = new JTable();
		
		scrollPane.setViewportView(table);
		table.setColumnSelectionAllowed(true);
		/*
		 * action performed, when any cell values has been changed
		 */
		Action action = new AbstractAction() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				System.out.println("");
				TableCellListener tcl = (TableCellListener)e.getSource();
		        if(tcl.getColumn()!=0)rows.add(tcl.getRow()); // if the value being changed is not from the first column, the index of row changed is added to the list of rows(see variable declaration)
		        else{// else if the boolean value is changed to 'true' the other values are changed to 'false'
		        	int row = tcl.getRow();
		        	int rowCount = table.getRowCount();
		        	if((boolean) table.getModel().getValueAt(row, 0)){
		        		for(int i = 0; i<rowCount; i++)table.getModel().setValueAt(false, i, 0);
		        		table.getModel().setValueAt(true, row, 0);
		        	}
		        }
				
			}
		};
		TableCellListener tcl = new TableCellListener(table, action);
		setTitle("Order");//title of the frame
		ordCtr = new OrderCtr();
		
		//get all orders from database and fill the table
		try{
			clearTable();
			fillTable();
		}
		catch(NullPointerException npe){
			JOptionPane.showMessageDialog(contentPane, "Database error");
		}
		
		//basic operations for GUI
		setDefaultCloseOperation(OrderGUI.DISPOSE_ON_CLOSE);
		setBounds(100, 100, 630, 500);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		
		
		
		//Create button which opens the create order window and disposes the current window
		btnCreate = new JButton("Create");
		btnCreate.setBounds(16, 421, 75, 23);
		btnCreate.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				CreateOrderGUI frame1 = new CreateOrderGUI();
				frame1.show();
				dispose();
			}
		});

		
		//Delete button with ActionListener
		btnDelete = new JButton("Delete");
		btnDelete.setBounds(101, 421, 77, 23);
		btnDelete.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				boolean deleted = false; // says if any row has been deleted
				int rowCount = table.getRowCount(); // number of rows in the table
				int option = JOptionPane.showConfirmDialog(contentPane, "Delete selected order?", "Request", 2);//request dialog 
				if (option == 0){ //if the choice is yes
					for(int i=0; i<rowCount; i++){ // for i.row to the last
						try{//this part of code was throwing an exception, even though everything was executed correctly
							boolean selected = (boolean) table.getModel().getValueAt(i,0);// get boolean value for the i row in the 1.column of the table
							if(selected){
								int id = (int) table.getModel().getValueAt(i, 1);//if true get id of the product
								ordCtr.deleteOrder(id); //delete order from the database
								((DefaultTableModel)table.getModel()).removeRow(i);//remove the row in the table
								deleted = true;//says that row has been deleted
								}
							}
							catch(ArrayIndexOutOfBoundsException e){
							}
						}
					if(!deleted) JOptionPane.showMessageDialog(contentPane, "Select Order!"); //if nothing has been deleted, no order was selected and the user is alerted
						
					}	
				}
		});
		/*
		 * button click for editing orders
		 * 
		 */
		btnEdit = new JButton("Edit");
		btnEdit.setBounds(188, 421, 61, 23);
		btnEdit.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
					for(int i: rows){ //only for rows, which has been edited
						int id = (int) table.getModel().getValueAt(i, 1);
						SalesOrder sale = ordCtr.findOrder(id);
						String status = (String) table.getModel().getValueAt(i,4);
						boolean deliveryStatus = false;
						if(status == "Delivered") deliveryStatus = true;
						//updates order and stores into the database
						ordCtr.updateOrder(id, sale.getTimeStamp(), (double) table.getModel().getValueAt(i,6), deliveryStatus,(String) table.getModel().getValueAt(i,5), sale.getCustomer(), sale.getInvoice(), sale.getOrderList());
					}
					rows = new ArrayList<Integer>();//empty the list
				}
		});
		contentPane.setLayout(null);
		
		lblId = new JLabel("ID:");
		lblId.setBounds(406, 22, 15, 14);
		contentPane.add(lblId);
		
		textField = new JTextField();
		textField.setBounds(431, 19, 86, 20);
		contentPane.add(textField);
		textField.setColumns(10);
		/*
		 * search order by id and print it in the table
		 */
		btnNewButton = new JButton("Search");
		btnNewButton.setBounds(527, 19, 77, 20);
		btnNewButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int id = 0;
				try{
					id = Integer.parseInt(textField.getText());
					SalesOrder sale = ordCtr.findOrder(id);
					String status = "";
					if(sale.getDeliveryStatus())status = "delivered";
					else status = "pending";
					//creating table model with only one row
					dtm = (new DefaultTableModel(
							new Object[][] {
									{
										true, sale.getOrderID(), sale.getCustomer().getCPR(), sale.getTimeStamp(),sale.getDeliveryDate(), status, sale.getAmount()}
							},
						new String[] {
							"", "Order ID", "CPR", "Time Stamp", "Status", "Delivery Date", "Amount"
							}
							) {
							Class[] columnTypes = new Class[] {
									Boolean.class, Integer.class, String.class, String.class, String.class, String.class, Double.class
							};
							public Class getColumnClass(int columnIndex) {
								return columnTypes[columnIndex];
							}
							boolean[] columnEditables = new boolean[] {
									true, false, false, false, true, true, true
							};
							public boolean isCellEditable(int row, int column) {
								return columnEditables[column];
							}
						});
				table.setModel(dtm);
				table.getColumnModel().getColumn(0).setPreferredWidth(30);
				table.getColumnModel().getColumn(1).setPreferredWidth(45);
				table.getColumnModel().getColumn(3).setPreferredWidth(130);
				btnShowAll.setVisible(true);//makes button show all visible
			}
				catch(NullPointerException e1){//if such an order doesn't exist
					JOptionPane.showMessageDialog(contentPane, "Order doesn't exist!");
				}
				catch(NumberFormatException nfe){//if no valid integer is entered
					JOptionPane.showMessageDialog(contentPane,"Enter valid number");
				}
			}
		});
		contentPane.add(btnNewButton);
		contentPane.add(btnCreate);
		contentPane.add(btnDelete);
		contentPane.add(btnEdit);
		contentPane.add(scrollPane);
		
		/*
		 * button click for printing invoice
		 */
		btnPrintInvoice = new JButton("Print Invoice");
		btnPrintInvoice.setBounds(260, 421, 111, 23);
		btnPrintInvoice.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				boolean printed = false;//says if any invoice has been printed or not 
				int rowCount = table.getRowCount(); // number of rows in the table
					for(int i=0; i<rowCount; i++){ // for i.row to the last
						boolean selected = (boolean) table.getModel().getValueAt(i,0);// get boolean value for the i row in the 1.column of the table
						if(selected == true){
							int id = (int) table.getModel().getValueAt(i, 1);//if true get id of the product
							SalesOrder sale = ordCtr.findOrder(id); //find order from the database
							System.out.println(sale.getInvoice());
							printed = true;//invoice has been printed
							}
						
						}
					if(!printed) JOptionPane.showMessageDialog(contentPane, "Select Order!");//invoice has not been printed
						
					}	
		});
		contentPane.add(btnPrintInvoice);
		
		/*
		 * button click for showing all the orders again
		 * button is visible, after certain order has been searched
		 */
		btnShowAll = new JButton("Show All");
		btnShowAll.setVisible(false);
		btnShowAll.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				clearTable();//clears table
				fillTable();// fills table *check the methods
				btnShowAll.setVisible(false);//makes the button disappear again
			}
		});
		btnShowAll.setBounds(16, 18, 89, 23);
		contentPane.add(btnShowAll);
	}
	/*
	 * method for filling the table with information
	 * about the orders
	 */
	public void fillTable(){
		orders = ordCtr.getAllOrders();
		for(SalesOrder salOrd: orders){
			
			//sets preffered width for some columns
			table.getColumnModel().getColumn(0).setPreferredWidth(30);
			table.getColumnModel().getColumn(1).setPreferredWidth(45);
			table.getColumnModel().getColumn(3).setPreferredWidth(130);
			
			//Initialise variables for filling table
			int ID = salOrd.getOrderID();
			String cPR = salOrd.getCustomer().getCPR();
			String timeStamp = salOrd.getTimeStamp();
			boolean status = salOrd.getDeliveryStatus();
			String stat;
			if(status){
				stat = "Delivered";
				dcbm.setSelectedItem("Delivered");
			}
			else {
				stat = "Pending";
				dcbm.setSelectedItem("Pending");
			}
			double amount = salOrd.getAmount();
			String deliveryDate = salOrd.getDeliveryDate();
			
			//create combo box
			JComboBox combo = new JComboBox<>();
			combo.setModel(dcbm);
			
			//add the values to the table
			Object[] rowData = {Boolean.FALSE,ID,cPR,timeStamp,stat,deliveryDate, amount};
			dtm.addRow(rowData);
			
			//make status cells combo boxes
			TableColumn state = table.getColumnModel().getColumn(4);
			state.setCellEditor(new DefaultCellEditor(combo));
		}
		
	}
	
	/*
	 * Clear Table, set data model 
	 */
	@SuppressWarnings("serial")
	public void clearTable(){
		dtm = (new DefaultTableModel(
				new Object[][] {
					
				},
				new String[] {
					"", "Order ID", "CPR", "Time Stamp", "Status", "Delivery Date", "Amount"
				}
			) {
				
				Class[] columnTypes = new Class[] {
					Boolean.class, Integer.class, String.class, String.class, JComboBox.class, String.class, Double.class
				};
				public Class getColumnClass(int columnIndex) {
					return columnTypes[columnIndex];
				}
				boolean[] columnEditables = new boolean[] {
					true, false, false, false, true, true, true
				};
				public boolean isCellEditable(int row, int column) {
					return columnEditables[column];
				}
			});
	
		table.setModel(dtm);
		
		}
	
	}

