package ns3.animator.app.view.comp;
import java.awt.BorderLayout;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class ArrayListComboBoxModel extends AbstractListModel implements
    ComboBoxModel {
  private Object selectedItem;

  private ArrayList anArrayList;

  public ArrayListComboBoxModel(ArrayList arrayList) {
    anArrayList = arrayList;
  }

  public Object getSelectedItem() {
    return selectedItem;
  }

  public void setSelectedItem(Object newValue) {
    selectedItem = newValue;
  }

  public int getSize() {
    return anArrayList.size();
  }

  public Object getElementAt(int i) {
    return anArrayList.get(i);
  }

  public static void main(String args[]) {
    JFrame frame = new JFrame("ArrayListComboBoxModel");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    Collection col = System.getProperties().values();
    ArrayList arrayList = new ArrayList(col);
    ArrayListComboBoxModel model = new ArrayListComboBoxModel(arrayList);

    JComboBox comboBox = new JComboBox(model);

    Container contentPane = frame.getContentPane();
    contentPane.add(comboBox, BorderLayout.NORTH);
    frame.setSize(300, 225);
    frame.setVisible(true);
  }
}