package ns3.animator.app.view.comp;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Vector;

import javax.swing.JLabel;
import javax.swing.JPanel;

import ns3.animator.app.globle.NsGVar;
import ns3.animator.app.objs.Ns3ConfigurationDataObj;

public class DrawingCanvas extends JPanel {
	
	
	
    /**
	 * 
	 */
	private static final long serialVersionUID = 8141280771369550552L;
    
    Object selectedShape;

    Rectangle2D boundingRec;
    
    JLabel location;
   
    Cursor curCursor;
    
    
    Vector<Ns3ConfigurationDataObj> n3NodeContainer;
    
    
    public DrawingCanvas(JLabel location) {
    	
    super();
    n3NodeContainer= new Vector<Ns3ConfigurationDataObj>();
    this.location=location;
//      x = 20;
//      y = 20;
//      w = 100;
//      h = 75;
      setBackground(Color.white);
      addMouseListener(new MyMouseListener(this));
      addMouseMotionListener(new MyMouseMotionListener(this));
      
      
      
    }
    public void paint(Graphics g) {
      Graphics2D g2D = (Graphics2D) g;
      
      if (boundingRec != null) {
        drawHighlightSquares(g2D, boundingRec);
      }
      
      if (curCursor != null)
        setCursor(curCursor);
      
      // drawing rectangol
      for(Ns3ConfigurationDataObj rectNode: n3NodeContainer){
    	 
          g2D.setColor(Color.BLUE);
          g2D.fill(rectNode.getNodeRect());
           }
    }
    
    public void drawHighlightSquares(Graphics2D g2D, Rectangle2D r) {
      double x = r.getX();
      double y = r.getY();
      double w = r.getWidth();
      double h = r.getHeight();
      g2D.setColor(Color.black);

      g2D.fill(new Rectangle.Double(x - 3.0, y - 3.0, 6.0, 6.0));
      g2D.fill(new Rectangle.Double(x + w * 0.5 - 3.0, y - 3.0, 6.0,
              6.0));
      g2D.fill(new Rectangle.Double(x + w - 3.0, y - 3.0, 6.0, 6.0));
      g2D
          .fill(new Rectangle.Double(x - 3.0, y + h * 0.5 - 3.0, 6.0,
              6.0));
      g2D.fill(new Rectangle.Double(x + w - 3.0, y + h * 0.5 - 3.0, 6.0,
          6.0));
      g2D.fill(new Rectangle.Double(x - 3.0, y + h - 3.0, 6.0, 6.0));
      g2D.fill(new Rectangle.Double(x + w * 0.5 - 3.0, y + h - 3.0, 6.0,
          6.0));
      g2D.fill(new Rectangle.Double(x + w - 3.0, y + h - 3.0, 6.0, 6.0));
    }

    class MyMouseListener extends MouseAdapter {
    	
    	DrawingCanvas canvas;
    	public MyMouseListener(DrawingCanvas canvas){
    		this.canvas=canvas;
    		
    	}
    	
    	
    	
      public void mousePressed(MouseEvent e) {
    	  
//    	  // show border
//        if (ellipse.contains(e.getX(), e.getY())) {
//        	
//        	selectedShape = ellipse;
//        	
//          if (boundingRec != null)
//            boundingRec = ellipse.getBounds2D();
//          displayParameters(selectedShape);
//        } else { 
//          boundingRec = null;
//          location.setText("");
//        }
//        canvas.repaint();
//        x1 = e.getX();
//        y1 = e.getY();
    	  
    	  for(Ns3ConfigurationDataObj node:n3NodeContainer){
    		  if(node.getNodeRect().contains(e.getX(),e.getY())){
    			  selectedShape = node.getNodeRect();
    			  if (boundingRec != null)
    	            boundingRec = node.getNodeRect().getBounds2D();
    	          displayParameters((Rectangle2D)selectedShape);
    	          break;
    		  } else { 
    	          boundingRec = null;
    	          location.setText("");
    	        }
    		  }
    		  
    	  
    	  
      }
      
      
      public void mouseReleased(MouseEvent e) {
    	  
    	  for(Ns3ConfigurationDataObj node:n3NodeContainer){
    		  if(node.getNodeRect().contains(e.getX(),e.getY())){
    			  selectedShape = node.getNodeRect();
    	          boundingRec = node.getNodeRect().getBounds2D();
    	          displayParameters((Rectangle2D)selectedShape);
    	          break;
    		  } 
    	  }
    	
        canvas.repaint();
      }

      public void mouseClicked(MouseEvent e) {
    	  
    	 if(e.getClickCount()==1){ 
    		 System.out.println(n3NodeContainer.size());
    		 for(Ns3ConfigurationDataObj node:n3NodeContainer){
    		  if(node.getNodeRect().contains(e.getX(),e.getY())){
    			  selectedShape = node.getNodeRect();    			  
    	          boundingRec = node.getNodeRect().getBounds2D();
    	          displayParameters((Rectangle2D)selectedShape);
    	          break;
    		  } else { 
    	          boundingRec = null;
    	          location.setText("");
    	        }
    		  }
    	 }
     
    	 
        if(e.getClickCount()==2){
        	Ns3ConfigurationDataObj ns3Node= new Ns3ConfigurationDataObj();
        	ns3Node.setNodeRect(new Rectangle2D.Double(e.getX() - 10.0, e.getY() - 10.0, 20.0, 20.0));        			
      	  	n3NodeContainer.add(ns3Node);
        }
        
        canvas.repaint();
      }
      
     
      
    }
    class MyMouseMotionListener extends MouseMotionAdapter {
    	
    	DrawingCanvas canvas;
    	
    	public MyMouseMotionListener(DrawingCanvas canvas){
    		this.canvas=canvas;
    	}	
    	
      public void mouseDragged(MouseEvent e) {
    	  
    	  System.out.println();
    	  for(Ns3ConfigurationDataObj node:n3NodeContainer){
    		  if(node.getNodeRect().contains(e.getX()+node.getNodeRect().getWidth()/2,e.getY()+node.getNodeRect().getHeight()/2)){
    			 
    	           			  
    			  selectedShape = node.getNodeRect();
//    			  double x = node.getNodeRect().getX(); 
//    			  double y = node.getNodeRect().getY();
    			  double x1 =  e.getX();
    			  double y1 = e.getY();
//    			  if(node.getLastMovePosX()==0.0&&node.getLastMovePosY()==0.0){
//    				  node.setLastMovePosX(x);
//    				  node.setLastMovePosY(y);
//    			  }
    			  
    			  node.getNodeRect().setRect(x1,y1, NsGVar.NODE_WIDTH, NsGVar.NODE_HEIGHT);
//    			  System.out.println("x:"+x);
    			  System.out.println("x1:"+x1);
//    			  System.out.println("node.getLastMovePosX():"+node.getLastMovePosX());
//    			  System.out.println("final:"+(x+x1-node.getLastMovePosX()));
//    			  System.out.println("------------------------------------");
//    			  node.setLastMovePosX(x1);
//    			  node.setLastMovePosY(y1);
    			  
    		
    			  
//    	          x2 = e.getX();
//    	          y2 = e.getY();
//    	          x = x + x2 - x1;
//    	          y = y + y2 - y1;
//    	          x1 = x2;
//    	          y1 = y2;
    		  } 
//    			  else { 
//    	          boundingRec = null;
//    	          location.setText("");
//    	        }
    		  }
    	  
        if (selectedShape != null)
        displayParameters((Rectangle2D)selectedShape);
        canvas.getParent().repaint();
        canvas.repaint();
        
      }

      public void mouseMoved(MouseEvent e) {
    	  
    	  
    	  for(Ns3ConfigurationDataObj node:n3NodeContainer){
    		  if(node!=null)
    		  if(node.getNodeRect().contains(e.getX(),e.getY())){
    			  curCursor = Cursor
    		                .getPredefinedCursor(Cursor.HAND_CURSOR);
    		  } else {
    	            curCursor = Cursor.getDefaultCursor();
              }
    		  
    		  }
    	  
        canvas.getParent().repaint();
        canvas.repaint();        
      }
    }

    public void displayParameters(Rectangle2D shape) {
    	   
      double x = shape.getX();
      double y = shape.getY();
      double w = shape.getWidth();
      double h = shape.getHeight();
      String locString = "(" + Double.toString(x) + ","
          + Double.toString(y) + ")";
      String sizeString = "(" + Double.toString(w) + ","
          + Double.toString(h) + ")";
      location.setText(locString);
    }
  }