/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.xfuze.tool.lang;

/**
 * @author Jason Chan
 *
 */
public final class Constant {
	private Constant() {
	}

	public static final String CONFIGURATION_FILE = "config.xml";

	public static final String DATABASE_DRIVER = "database.driver";
	public static final String DATABASE_URL = "database.url";
	public static final String DATABASE_USERNAME = "database.username";
	public static final String DATABASE_PASSWORD = "database.password";

	public static final String TABLE_NAME_PATTERN = "table.name.pattern";
	public static final String TABLE_NAME_SUFFIX = "table.name.suffix";

	public static final String PRIMARY_KEY_GENERATED = "primary.key.generated";

	public static final String MODEL_PATH = "path.model";
	public static final String MODEL_SUFFIX = "model.suffix";
	public static final String MODEL_PACKAGE = "model.package";

	public static final String DAO_PATH = "path.dao";
	public static final String DAO_SUFFIX = "dao.suffix";
	public static final String DAO_PACKAGE = "dao.package";

	public static final String DAO_IMPL_PATH = "path.dao.impl";
	public static final String DAO_IMPL_SUFFIX = "dao.impl.suffix";
	public static final String DAO_IMPL_PACKAGE = "dao.impl.package";

	public static final String SERVICE_PATH = "path.service";
	public static final String SERVICE_SUFFIX = "service.suffix";
	public static final String SERVICE_PACKAGE = "service.package";

	public static final String SERVICE_IMPL_PATH = "path.service.impl";
	public static final String SERVICE_IMPL_SUFFIX = "service.impl.suffix";
	public static final String SERVICE_IMPL_PACKAGE = "service.impl.package";

	public static final String SERVICE_TEST_PATH = "path.service.test";
	public static final String SERVICE_TEST_SUFFIX = "service.test.suffix";
	public static final String SERVICE_TEST_PACKAGE = "service.test.package";

	public static final String SPRING_PATH = "path.spring";

	public static final String SQLMAP_PATH = "path.sqlmap";
	public static final String SQLMAP_DATABASE = "sqlmap.database";
	public static final String SQLMAP_CONTROL_UPDATE = "control.update";
	public static final String SQLMAP_CONTROL_DELETE = "control.delete";
	public static final String SQLMAP_HANDLER_LIKE_NAME = "handler.like.name";
	public static final String SQLMAP_HANDLER_LIKE_CLASS = "handler.like.class";

	public static final String SCHEMA_PATH = "path.schema";























}
