import sys
sys.path.insert(0, '../')

from blocksworld_environment.blocksworld_environment import BlocksWorld

import os
if not os.path.exists("test_logs"):
    os.makedirs("test_logs")
output_file = open("test_logs/blocksworld.txt", "w")

def test_blocksworld_environment():
    env = BlocksWorld(6)
    print(env.describe_interface(), file=output_file)
    env.set_state((['a', 'b', 'c'], ['d', 'f']))
    for block in env.blocks.values():
        print(block.name, block.below, block.on_top_of)
    env.reset()
    #print(env.step('<stack b a>'))
    print(env.describe_state(), file=output_file)
    print(env.describe_available_actions(), file=output_file)
    print(env.step('<pick up a>'), file=output_file)
    print({block.name: block.total_height for block in env.clear}, file=output_file)
    print(env.describe_available_actions(), file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.step('<put down a>'), file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.step('<measure a>'))
    print(env.describe_available_actions(), file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.step('<pick up b>'), file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.step('<stack b on a>'), file=output_file)
    print({block.name: block.total_height for block in env.clear}, file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.step('<pick up c>'), file=output_file)
    print({block.name: block.total_height for block in env.clear}, file=output_file)
    print(env.available_actions, file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.step('<stack c on b>'), file=output_file)
    print({block.name: block.total_height for block in env.clear}, file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.step('<pick up d>'), file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.step('<stack d on c>'), file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.step('<pick up f>'), file=output_file)
    print({block.name: block.total_height for block in env.clear}, file=output_file)
    print(env.height_of_highest_tower, file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.step('<stack f on e>'), file=output_file)
    print(env.get_state(), file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.height_of_highest_tower, file=output_file)
    print(env.most_blocks_in_a_tower, file=output_file)
    print(env.total_questions_asked, file=output_file)
    print(env.step('<unstack f>'), file=output_file)
    print(env.describe_state(), file=output_file)
    print(env.describe_state({'towers': [env.block_names]}), file=output_file)
