#!/bin/bash
#SBATCH --job-name=HSCeval
#SBATCH --output=output_%A_%a.out
#SBATCH --error=error_%A_%a.out
#SBATCH --array=1-5
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=1
#SBATCH --mem-per-cpu=16G
#SBATCH --gres=gpu:1
#SBATCH --time=01:00:00

seed=$SLURM_ARRAY_TASK_ID

source ~/.bashrc
conda activate upfi

PYTORCH_CUDA_ALLOC_CONF=expandable_segments:True python run_evals.py $seed
