#!/bin/bash
#SBATCH --job-name=bf
#SBATCH --output=output_%A_%a.out
#SBATCH --error=error_%A_%a.out
#SBATCH --array=1-5
#SBATCH --ntasks=1
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=1
#SBATCH --mem-per-cpu=16G
#SBATCH --time=04:00:00

source ~/.bashrc
conda activate upfi

seed=$SLURM_ARRAY_TASK_ID

c=0.5
beta=5.0
reg=vf
N=500

teacherforcing=true
train_iters=10000
_teacherforcingits=$([ $teacherforcing = true ] && echo $train_iters || echo 0)

#    --train_score --train_pfi --train_upfi --train_ode --train_tigon  \
python ../../src/train_cmd.py --data "sim_BF_beta_"$beta"_N_"$N"_T_10_c_"$c".pkl" --suffix "default_beta_"$beta"_c_"$c"_seed_"$seed \
    --train_ode --train_tigon  \
    --train_score_iters 10000 --train_score_batch 256 --train_score_lr 1e-2 --hidden_sizes_score 64 64 64 \
    --train_upfi_iters $train_iters --train_upfi_batch 256 --train_upfi_lr 3e-3 --train_upfi_reg $reg --train_upfi_teacherforcing_its $_teacherforcingits --hidden_sizes_upfi 64 64 64 \
    --train_pfi_iters $train_iters --train_pfi_batch 256  --train_pfi_lr 3e-3 --train_pfi_reg $reg --train_pfi_teacherforcing_its $_teacherforcingits --hidden_sizes_pfi 64 64 64 \
    --train_ode_iters $train_iters  --train_ode_batch 256 --train_ode_lr 3e-3 --train_ode_teacherforcing_its $_teacherforcingits --hidden_sizes_ode 64 64 64 \
    --train_tigon_iters $train_iters --train_tigon_batch 256 --train_tigon_reg $reg --train_tigon_lr 3e-3 --train_tigon_teacherforcing_its 0 --hidden_sizes_tigon 64 64 64 \
    --reach 5.0 --reg_wfr 0.001 --alpha_wfr 1 \
    --score_logsigma_min -2 --score_logsigma_max 0 \
    --sigma_anneal_iters $([ $teacherforcing = true ] && echo None || echo 2000) \
    --D 0.25 \
    --outdir weights --figdir plots --seed $seed
