#!/bin/bash
#SBATCH --job-name=BF
#SBATCH --output=output_%A_%a.out
#SBATCH --error=error_%A_%a.out
#SBATCH --array=1-5
#SBATCH --ntasks=1
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=1
#SBATCH --mem-per-cpu=16G
#SBATCH --time=04:00:00

source ~/.bashrc
conda activate upfi

seed=$SLURM_ARRAY_TASK_ID

c=0.5
beta=5.0
reg=vf
N=500

teacherforcing=true
train_iters=10000
_teacherforcingits=$([ $teacherforcing = true ] && echo $train_iters || echo 0)

python ../../src/train_multnoise.py --data "sim_BF_beta_"$beta"_N_"$N"_T_10_c_"$c".pkl" --suffix "default_beta_"$beta"_c_"$c"_seed_"$seed \
    --train_mult_upfi --train_mult_pfi \
    --hidden_sizes_score 64 64 64 \
    --train_mult_upfi_iters $train_iters --train_mult_upfi_batch 256 --train_mult_upfi_lr 3e-3 --train_mult_upfi_reg $reg --train_mult_upfi_teacherforcing_its $_teacherforcingits --hidden_sizes_mult_upfi 64 64 64 \
    --train_mult_pfi_iters $train_iters --train_mult_pfi_batch 256 --train_mult_pfi_lr 3e-3 --train_mult_pfi_reg $reg --train_mult_pfi_teacherforcing_its $_teacherforcingits --hidden_sizes_mult_pfi 64 64 64 \
    --reach 5 --reg_wfr 0.001 --alpha_wfr 1 \
    --score_logsigma_min -2 --score_logsigma_max 0 \
    --sigma_anneal_iters $([ $teacherforcing = true ] && echo None || echo 2000) \
    --D 0.25 \
    --outdir weights --figdir plots --seed $seed
