#!/bin/bash
#SBATCH --job-name=bifurc
#SBATCH --output=output_%A_%a.out
#SBATCH --error=error_%A_%a.out
#SBATCH --array=1-5
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=1
#SBATCH --mem-per-cpu=16G
#SBATCH --gres=gpu:1
#SBATCH --time=04:00:00

seed=$SLURM_ARRAY_TASK_ID

source ~/.bashrc
conda activate upfi

T=5;
reg=vf # jac
# dim=10; beta=5.0; N=500
# dim=5; beta=5.0; N=500
dim=2; beta=5.0; N=500

teacherforcing=false
train_iters=5000

_teacherforcingits=$([ $teacherforcing = true ] && echo $train_iters || echo 0)
suffix="default"$([ $teacherforcing = true ] && echo "_teacherforcing_" || echo "_")"reg_"$reg"_T_"$T"_dim"$dim"_beta_"$beta"_seed_"$seed

echo $suffix

echo "RUNNING EVALS"
python ../../src/run_evals.py --seed $seed --data "sim_twowell_N_"$N"_T_"$T"_dim_"$dim"_D_0.25_beta_"$beta".pkl" --suffix $suffix \
	   --hidden_sizes_upfi_g 64 64 64 \
	   --deepruot_suffix "dim_"$dim"_beta_"$beta \
	   --score_logsigma_min -2 --score_logsigma_max 0 \
	   --D 0.25 \
	   --outdir weights --figdir plots --evaldir evals

