#!/bin/bash
#SBATCH --job-name=bifurc_deepRUOT
#SBATCH --output=output_%A_%a.out
#SBATCH --error=error_%A_%a.out
#SBATCH --array=1-3
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=1
#SBATCH --mem-per-cpu=16G
#SBATCH --gres=gpu:1
#SBATCH --time=04:00:00

params=(
    "10 5.0"
    "5 5.0"
    "2 5.0"
)

N=500

parameterArray=(${params[$SLURM_ARRAY_TASK_ID-1]})
dim=${parameterArray[0]}
beta=${parameterArray[1]}

python ../../../src/run_deepruot.py "../sim_twowell_N_"$N"_T_5_dim_"$dim"_D_0.25_beta_"$beta".pkl" "dim_"$dim"_beta_"$beta
