#!/bin/bash
#SBATCH --job-name=larry
#SBATCH --output=output_%A_%a.out
#SBATCH --error=error_%A_%a.out
#SBATCH --array=1-5
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=1
#SBATCH --mem-per-cpu=16G
#SBATCH --gres=gpu:1
#SBATCH --time=01:00:00

seed=$SLURM_ARRAY_TASK_ID

source ~/.bashrc
conda activate upfi

reg=vf
dim=10
T=3
teacherforcing=true
train_iters=10_000

_teacherforcingits=$([ $teacherforcing = true ] && echo $train_iters || echo 0)
suffix="default_additive_pcadim_"$dim"_seed_"$seed

echo $suffix

python ../../src/train_cmd.py --data data_pca.pkl --suffix $suffix \
    --train_score --train_upfi --train_pfi --train_tigon --train_ode \
    --train_score_iters 10_000 --train_score_ckpt 1000 --train_score_batch 256 --train_score_lr 1e-2 --hidden_sizes_score 128 128 128 \
    --train_upfi_iters $train_iters --train_upfi_batch 256 --train_upfi_reg $reg --train_upfi_lr 1e-3 --train_upfi_teacherforcing_its $_teacherforcingits --train_upfi_g_type aut \
    --hidden_sizes_upfi 128 128 128 --hidden_sizes_upfi_g 128 128 128 \
    --train_pfi_iters $train_iters --train_pfi_batch 256 --train_pfi_reg $reg --train_pfi_lr 1e-3 --train_pfi_teacherforcing_its $_teacherforcingits \
    --hidden_sizes_pfi 128 128 128 \
    --train_ode_iters $train_iters --train_ode_batch 256 --train_ode_lr 1e-3 --train_ode_teacherforcing_its $_teacherforcingits --hidden_sizes_ode 128 128 128 \
    --train_tigon_iters $train_iters --train_tigon_batch 256 --train_tigon_reg $reg --train_tigon_lr 1e-3 --train_tigon_teacherforcing_its 0 --hidden_sizes_tigon 128 128 128 \
    --reach 25.0 --reg_wfr 0.001 --alpha_wfr 1 \
    --score_logsigma_min -2 --score_logsigma_max 0 --print_iter 500 --sigma_anneal_iters None  --D 0.25 \
    --outdir weights --figdir plots --seed $seed --dt_ratio 5
