import matplotlib.pyplot as plt
from scipy.interpolate import griddata
import numpy as np

def plot_stream_vectorfield(x, v, ax = None, x_min = None, x_max = None, y_min = None, y_max = None, N = 15, linewidth = None, lw0 = 1.0, **kwargs):
    x_min = x[:, 0].min() if x_min is None else x_min
    x_max = x[:, 0].max() if x_max is None else x_max
    y_min = x[:, 0].min() if y_min is None else y_min
    y_max = x[:, 0].max() if y_max is None else y_max
    _x, _y = np.meshgrid(np.linspace(x_min, x_max, N), np.linspace(y_min, y_max, N))
    _u = griddata((x[:, 0], x[:, 1]), v[:, 0], (_x, _y), method='linear', fill_value = 0)
    _v = griddata((x[:, 0], x[:, 1]), v[:, 1], (_x, _y), method='linear', fill_value = 0)
    speed = np.sqrt(_u**2 + _v**2)
    lw = 5*speed / speed.max() * lw0
    if ax is None:
        plt.streamplot(_x, _y, _u, _v, linewidth = lw if linewidth is None else linewidth, **kwargs)
    else:
        ax.streamplot(_x, _y, _u, _v, linewidth = lw if linewidth is None else linewidth, **kwargs)
