#!/bin/bash
#
#SBATCH -N 1
#SBATCH -t 1-00:00
#SBATCH -o ./log/%j.out
#SBATCH -e ./log/%j.err
#SBATCH -a 0-9

source ./env.sh

if [ -z $N_STATES ]; then
    N_STATES=25
fi

if [ -z $LR ]; then
    LR=1e-4
fi

if [ -z $N_EPOCHS ]; then
    N_EPOCHS=300
fi

if [ -z $SHUFFLE ]; then
    SHUFFLE=""
else
    SHUFFLE="--shuffle"
fi

SEED=$SLURM_ARRAY_TASK_ID

python3 train2.py --env darkroom --n_states $N_STATES $SHUFFLE --n_epochs $N_EPOCHS --lr $LR --seed $SEED
