from typing import Sequence

import torch
from torch import Tensor


def uniform_random(size: Sequence[int], scale: float = 1.0, device=None, dtype=None) -> Tensor:
    rand_0_1 = torch.rand(size, device=device, dtype=dtype)
    rand_m1_1 = rand_0_1 * 2 - 1
    return rand_m1_1 * scale
