#!/bin/bash
#
#SBATCH -N 1
#SBATCH -t 0-02:00
#SBATCH -o ./log/%j.out
#SBATCH -e ./log/%j.err

if [ -z $AGAINST ]; then
    echo "Missing AGAINST arg"
    exit 64
fi

source ./env.sh

if [ -z $N_ROUNDS ]; then
    N_ROUNDS=20
fi

if [ -z $EPS_STEPS ]; then
    EPS_STEPS=0.4
fi

python3 bandit_eval_alg_against_all_adaptive.py \
    --env bandit --arch 1 --variance 0.3 --context_len 500 --n_actions 5 --n_epochs 500 --epoch 400 \
    --n_envs_eval 200 --n_rounds $N_ROUNDS --n_seeds 10 --eps_steps $EPS_STEPS --eps_episodes 0.8 --attacker_against $AGAINST --attacker_lr 0.0003 \
    --adaptiveatt_arch 1 --adaptiveatt_context_len 500
