#!/bin/bash
#
#SBATCH -N 1
#SBATCH -t 1-00:00
#SBATCH -o ./log/%j.out
#SBATCH -e ./log/%j.err
#SBATCH -a 0-9

source ./env.sh

if [ -z $CTX_VICTIM ]; then
    CTX_VICTIM=500
fi

SEED=$SLURM_ARRAY_TASK_ID

train_params="--env bandit --arch 1 --H $CTX_VICTIM --dim 5 --var 0.3 --cov 0.0 --envs_eval 200 --num_epochs 500"

python3 train.py $train_params --seed $SEED
