import json

class BadcaseTracker:
    """
    追踪每个 input 文本对应的错误次数和相关 prompt，prompt 采用 text 去重。
    """
    def __init__(self):
        # key: input文本
        # value: {"count": int, "prompts": set of prompt文本}
        self.badcase_dict = {}

    def update(self, input_text, prompt_text):
        """
        更新某个 badcase 的信息
        """
        if input_text not in self.badcase_dict:
            self.badcase_dict[input_text] = {
                "count": 1,
                "prompts": set([prompt_text])
            }
        else:
            self.badcase_dict[input_text]["count"] += 1
            self.badcase_dict[input_text]["prompts"].add(prompt_text)

    def get_badcases(self):
        """
        获取所有的 badcase 信息
        """
        return self.badcase_dict

    def export(self, filepath):
        """
        导出 badcase 数据到 JSON 文件
        """
        export_dict = {
            k: {"count": v["count"], "prompts": list(v["prompts"])}
            for k, v in self.badcase_dict.items()
        }
        with open(filepath, "w", encoding="utf-8") as f:
            json.dump(export_dict, f, ensure_ascii=False, indent=2)