import hues
import csv
import time


def read_csv(_file_name, _delimiter=",", _dict=True):  # 默认分隔符为「,」，默认以字典方式返回每一行数据
    _file = open(_file_name, 'r')
    if _dict:
        _ds = list()
        for row in csv.DictReader(_file, delimiter=_delimiter):
            _ds.append(row)
    else:
        _ds = list(csv.reader(_file, delimiter=_delimiter))
    # hues.info('读取csv数据总数:', len(_ds))
    return _ds  # list<dict>


def output_csv(_file_name, _data):  # _data is a List, List value is a Dict
    with open(_file_name, 'w') as _file:
        _c = csv.writer(_file)
        for index, _line in enumerate(_data):
            if index == 0:
                _c.writerow(list(_line.keys()))
            _c.writerow(_line.values())
    hues.success(f'已将数据写入csv文件:{_file_name}')


### --------TEST-------- ###

if __name__ == '__main__':
    your_file_name = '$你的文件$.csv'  # 修改你的文件名
    ds = read_csv(_file_name=your_file_name, _delimiter=',', _dict=True)
    start_time = time.time()
    for _idx, v in enumerate(ds):
        hues.log(f'读取第{_idx}行数据:', v)

    hues.success(f"运行总耗时:{time.time() - start_time}s")
