import numpy as np

class ClusterArm:
    def __init__(self, cluster_id):
        self.cluster_id = cluster_id
        self.n_pulls = 0
        self.total_f1 = 0

    def pull(self, f1):
        """
        更新该臂的 F1 分数和拉取次数
        """
        self.n_pulls += 1
        self.total_f1 += f1

    def ucb_score(self, total_pulls):
        """
        计算该臂的 UCB 分数
        """
        if self.n_pulls == 0:
            return float('inf')
        return (self.total_f1 / self.n_pulls) + np.sqrt(2 * np.log(total_pulls) / self.n_pulls)