function [xx,dFa,d2Fa,aa] = feedforward (x0, biases, weights, N,drp_rate)


  xx=cell(N,1);%F(a)
  aa=cell(N,1);
  dFa=cell(N,1);% dF(a)
  d2Fa=cell(N,1);% d2F(a)
  % feedforward loop
  x=x0;
  for i = 1:N
    % reshape weight and biases
    w = weights{i,1};
    b = biases {i,1};
    % compute the activation function
    a=(w*x+b).*randsrc(length(b),1,[0,1;drp_rate,1-drp_rate]);%dropout
    aa{i,1}=a;
    xx{i,1}= sigmoid(a);
    dFa{i,1}= dsigmoid(a);
    d2Fa{i,1}= d2sigmoid(a);
     x=xx{i,1};% for the next loop
  end
end
