# ESCNN - GIE

## STL10

### for training
```sh
#stl10 simclr gie
python train.py --data 'data/stl10' --epochs 400 --batch-size 512 --learning-rate 0.6 --checkpoint-dir './experiments/gie_simclr' --alpha 0.0 --beta 0.1 --arch 'escnn18' --connector 'softmax' --pretrain-set 'stl10' --ssl 'simclr'
#stl10 simclr gie random rotation
python train.py --data 'data/stl10' --epochs 400 --batch-size 512 --learning-rate 0.6 --checkpoint-dir './experiments/gie_simclr_rot' --alpha 0.0 --beta 0.1 --arch 'escnn18' --connector 'softmax' --pretrain-set 'stl10' --ssl 'simclr' --rotation_degree 45 --circular_transform --circular_range 10
#stl10 simsiam gie
python train.py --data 'data/stl10' --epochs 400 --batch-size 512 --learning-rate 0.1 --checkpoint-dir './experiments/gie_simsiam' --alpha 0.0 --beta 0.1 --arch 'escnn18' --connector 'softmax' --pretrain-set 'stl10' --ssl 'simsiam'
#stl10 simsiam gie random rotation
python train.py --data 'data/stl10' --epochs 400 --batch-size 512 --learning-rate 0.1 --checkpoint-dir './experiments/gie_simsiam_rot' --alpha 0.0 --beta 0.1 --arch 'escnn18' --connector 'softmax' --pretrain-set 'stl10' --ssl 'simsiam' --rotation_degree 45 --circular_transform --circular_range 10
```


### linear classification accuracy of four discrete 90-degree orientations
```sh
# NR HX
python linear_probe.py --data '/data/stl10' --pretrained-dir './experiments/model' --epochs 100 --lr-classifier 1.0 --arch 'escnn18' --num-classes 10 --pretrain-set 'stl10' --eval-set 'stl10' --connector 'softmax' --inv_linear_probe

# R HX
python linear_probe.py --data '/data/stl10' --pretrained-dir './experiments/model' --epochs 100 --lr-classifier 1.0 --arch 'escnn18' --num-classes 10 --pretrain-set 'stl10' --eval-set 'stl10' --connector 'softmax' --inv_linear_probe --rotated
```


### linear classification accuracy of arbitrary degree orientations
```sh
# Random rotation
python linear_probe.py --data '/data/stl10' --pretrained-dir './experiments/model' --epochs 400 --lr-classifier 0.1 --arch 'escnn18' --num-classes 10 --pretrain-set 'stl10' --eval-set 'stl10' --connector 'softmax' --inv_linear_probe --random_rotation --circular_transform --circular_range 10
```

## ImageNet100

### for training
```sh
# imagenet100 simclr gie
python train.py --data '/data/imagenet100' --pretrain-set 'imagenet100' --batch-size 256 --checkpoint-dir './experiments/gie_simclr_imagenet100' --alpha 0.0 --beta 0.1 --arch 'escnn18' --connector 'softmax' --epochs 400 --ssl 'simclr' --learning-rate 0.3

# imagenet100 simclr gie random rotation
python train.py --data '/data/imagenet100' --pretrain-set 'imagenet100' --batch-size 256 --checkpoint-dir './experiments/gie_simclr_imagenet100_rot' --alpha 0.0 --beta 0.1 --arch 'escnn18' --connector 'softmax' --epochs 400 --ssl 'simclr' --learning-rate 0.3 --circular_transform --circular_range 22 --rotation_degree 45

# imagenet100 simsiam gie
python train.py --data '/data/imagenet100' --pretrain-set 'imagenet100' --batch-size 256 --checkpoint-dir './experiments/gie_simsiam_imagenet100' --alpha 0.0 --beta 0.1 --arch 'escnn18' --connector 'softmax' --epochs 400 --ssl 'simsiam' --learning-rate 0.05

# imagenet100 simsiam gie random rotation
python train.py --data '/data/imagenet100' --pretrain-set 'imagenet100' --batch-size 256 --checkpoint-dir './experiments/gie_simsiam_imagenet100_rot' --alpha 0.0 --beta 0.1 --arch 'escnn18' --connector 'softmax' --epochs 400 --ssl 'simsiam' --learning-rate 0.05 --circular_transform --circular_range 22 --rotation_degree 45
```


### linear classification accuracy of four discrete 90-degree orientations
```sh
# NR HX
python linear_probe.py --data '/data/imagenet100' --pretrain-set 'imagenet100' --epochs 100 --lr-classifier 1.0 --num-classes 100  --pretrained-dir './experiments/model' --eval-set 'imagenet100' --connector 'softmax' --inv_linear_probe

# R HX
python linear_probe.py --data '/data/imagenet100' --pretrain-set 'imagenet100' --epochs 100 --lr-classifier 1.0 --num-classes 100  --pretrained-dir './experiments/model' --eval-set 'imagenet100' --connector 'softmax' --inv_linear_probe --rotated
```


### linear classification accuracy of arbitrary degree orientations
```sh
# Random rotation
python linear_probe.py --data '/data/imagenet100' --pretrained-dir './experiments/model' --epochs 400 --lr-classifier 0.1 --arch 'escnn18' --num-classes 100 --pretrain-set 'imagenet100' --eval-set 'imagenet100' --connector 'softmax' --inv_linear_probe --random_rotation --circular_transform --circular_range 0
```

