from .ig import IG
from .cam import CAM
from .rise import RISE
from .xrai import XRAI
from .ig_guided import GuidedIG
from .traceback import TraceBack
from .traceback_topk import TraceTopk

__method_factory__ = {
    "ig": IG,
    "cam": CAM,
    "rise": RISE,
    "xrai": XRAI,
    "guidedig": GuidedIG,
    "traceback": TraceBack,
    "tracetopk": TraceTopk
}

def give_method(config, **kwargs):
    xai_name = config.xai_name
    method = __method_factory__[xai_name](**kwargs)
    return method