import torch.nn as nn
from typing import Tuple
from .visualizer import BaseVisualizer


def give_visualizer(config, model: nn.Module) -> Tuple[nn.Module, BaseVisualizer]:
    visualizer = BaseVisualizer()
    model = visualizer.wrap(model)
    return model, visualizer