# Online Continual Learning via Logit Adjusted Softmax 

## Method

<img src="./method.png" width="800">

## Requirements 
* python>=3.8
* pytorch>=1.8.1
* torchvision>=0.9.1
* numpy 
* pillow

## Repo Structure & Description
```
├── backbone                         # Folder for model backbones
├── data
    ├── CIFAR10                          # Folder of CIFAR10 dataset, require download
    ├── CIFAR100                         # Folder of CIFAR100 dataset, require download
    ├── TINYIMG                          # Folder of TinyImageNet dataset, require download
├── datasets
    ├── blurry_cifar100.py               # Define blurry CIFAR100        
    ├── blurry_tinyimagenet.py           # Define blurry TinyImageNet 
    ├── gen_cifar100.py                  # Define general TinyImageNet      
    ├── seq_cifar10.py                   # Define class-IL CIFAR10
    ├── seq_cifar100.py                  # Define class-IL CIFAR100        
    ├── seq_imagenet.py                  # Define class-IL ImageNet        
    ├── seq_inaturalist.py               # Define class-IL iNaturalist        
    ├── seq_tinyimagenet.py              # Define class-IL TinyImageNet      
├── models       
    ├── er_las.py                        # Experience Replay with Logit Adjusted Softmax
├── run
    ├── class_il.sh                      # Script to run on online class-IL Cl setup
    ├── imagenet.sh                      # Script to run on ImageNet of online class-IL Cl setup
    ├── inat.sh                          # Script to run on iNaturalist of online class-IL Cl setup
    ├── blurry.sh                        # Script to run on online blurry Cl setup
    ├── general.sh                       # Script to run on online general Cl setup
├── utils                            # Files for training
```

## Running Experiments 
For example,
* To run ER-LAS with $\tau=1.0$ and $l=1$ on CIFAR10 in online class-IL CL setup, buffer size is $0.5k$:
```
sh run/class_il.sh 0 er_las seq-cifar10 500 1.0 1
```
* To run ER-LAS with $\tau=1.0$ and $l=1$ on CIFAR100 in online class-IL CL setup, buffer size is $2k$:
```
sh run/class_il.sh 0 er_las seq-cifar100 2000 1.0 1
```
* To run ER-LAS with $\tau=1.0$ and $l=1$ on TinyImageNet in online class-IL CL setup, buffer size is $2k$:
```
sh run/class_il.sh 0 er_las seq-tinyimg 2000 1.0 1
```
* To run ER-LAS with $\tau=1.0$ and $l=10$ on ImageNet in online class-IL CL setup, buffer size is $20k$, filling in the path to ImageNet dataset in `datasets/seq_imagenet.py`:
```
sh run/imagenet.sh 0,1,2,3 er_las seq-imagenet 20000 1.0 10
```
* To run ER-LAS with $\tau=1.0$ and $l=10$ on iNaturalist in online class-IL CL setup, buffer size is $20k$, filling in the path to iNaturalist dataset in `datasets/seq_inaturalist.py`:
```
sh run/inat.sh 0,1,2,3 er_las seq-inat 20000 1.0 10
```
* To run ER-LAS with $\tau=1.0$ and $l=1$ on CIFAR100 in online blurry CL setup, buffer size is $2k$:
```
sh run/blurry.sh 0 er_las blurry-cifar100 2000 1.0 1
```
* To run ER-LAS with $\tau=1.0$ and $l=1$ on TinyImageNet in online blurry CL setup, buffer size is $2k$:
```
sh run/blurry.sh 0 er_las blurry-tinyimg 2000 1.0 1
```
* To run ER-LAS with $\tau=1.0$ and $l=1$ on CIFAR100 in online general CL setup, buffer size is $2k$:
```
sh run/general.sh 0 er_las gen-cifar100 2000 1.0 1
```

## Acknowledgments
[Mammoth](https://github.com/aimagelab/mammoth)