include(joinpath(@__DIR__, "traces.jl"))

for name in ["Banana", "Funnel", "WarpedGaussian", "Cross"]
    for tracetype in ["mcmc", "fwd_homo", "fwd_irf", "inv_irf", "bwd_irf", "bwd_inv_irf"]
        for kernel_type in [MF.RWMH, MF.MALA, MF.HMC]
            for seed in 1:32

                # run simulation
                df = run_traces(seed, name, kernel_type, tracetype)

                # save simulation results
                res_dir = joinpath(@__DIR__, "csvs/")
                if !isdir(res_dir)
                    mkpath(res_dir)
                end

                CSV.write(
                    joinpath(res_dir, "$(name)_$(tracetype)_$(kernel_type)_$(seed).csv"),
                    df,
                )

            end
        end
    end
end
