include(joinpath(@__DIR__, "uhmc_hmc.jl"))

n_sample = 256

for name in ["Banana", "Funnel", "WarpedGaussian", "Cross"]
    for kernel in [MF.HMC, MF.uncorrectHMC]
        for flowtype in [MF.DeterministicMixFlow]
            for flowlength in [300]
                for step_size in [0.01, 0.05, 0.1, 0.2]
                    for seed in 1:5

                        # run simulation
                        df = run_tv_sweep(seed, name, flowtype, kernel, flowlength, step_size; nsample=n_sample)

                        # save simulation results
                        res_dir = joinpath(@__DIR__, "csvs/")
                        if !isdir(res_dir)
                            mkpath(res_dir)
                        end

                        CSV.write(
                            joinpath(res_dir, "$(name)_$(kernel_type)_$(seed).csv"),
                            df,
                        )

                    end
                end
            end
        end
    end
end
